// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.MongoRoleDefinitionType;
import com.azure.resourcemanager.cosmos.models.Privilege;
import com.azure.resourcemanager.cosmos.models.Role;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * An Azure Cosmos DB Mongo Role Definition.
 */
@Fluent
public final class MongoRoleDefinitionGetResultsInner extends ArmProxyResource {
    /*
     * Properties related to the Mongo Role Definition.
     */
    @JsonProperty(value = "properties")
    private MongoRoleDefinitionResource innerProperties;

    /**
     * Creates an instance of MongoRoleDefinitionGetResultsInner class.
     */
    public MongoRoleDefinitionGetResultsInner() {
    }

    /**
     * Get the innerProperties property: Properties related to the Mongo Role Definition.
     *
     * @return the innerProperties value.
     */
    private MongoRoleDefinitionResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     *
     * @return the roleName value.
     */
    public String roleName() {
        return this.innerProperties() == null ? null : this.innerProperties().roleName();
    }

    /**
     * Set the roleName property: A user-friendly name for the Role Definition. Must be unique for the database account.
     *
     * @param roleName the roleName value to set.
     * @return the MongoRoleDefinitionGetResultsInner object itself.
     */
    public MongoRoleDefinitionGetResultsInner withRoleName(String roleName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withRoleName(roleName);
        return this;
    }

    /**
     * Get the type property: Indicates whether the Role Definition was built-in or user created.
     *
     * @return the type value.
     */
    public MongoRoleDefinitionType typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    /**
     * Set the type property: Indicates whether the Role Definition was built-in or user created.
     *
     * @param type the type value to set.
     * @return the MongoRoleDefinitionGetResultsInner object itself.
     */
    public MongoRoleDefinitionGetResultsInner withTypePropertiesType(MongoRoleDefinitionType type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withType(type);
        return this;
    }

    /**
     * Get the databaseName property: The database name for which access is being granted for this Role Definition.
     *
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.innerProperties() == null ? null : this.innerProperties().databaseName();
    }

    /**
     * Set the databaseName property: The database name for which access is being granted for this Role Definition.
     *
     * @param databaseName the databaseName value to set.
     * @return the MongoRoleDefinitionGetResultsInner object itself.
     */
    public MongoRoleDefinitionGetResultsInner withDatabaseName(String databaseName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withDatabaseName(databaseName);
        return this;
    }

    /**
     * Get the privileges property: A set of privileges contained by the Role Definition. This will allow application of
     * this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than
     * Database are not enforceable as privilege.
     *
     * @return the privileges value.
     */
    public List<Privilege> privileges() {
        return this.innerProperties() == null ? null : this.innerProperties().privileges();
    }

    /**
     * Set the privileges property: A set of privileges contained by the Role Definition. This will allow application of
     * this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher than
     * Database are not enforceable as privilege.
     *
     * @param privileges the privileges value to set.
     * @return the MongoRoleDefinitionGetResultsInner object itself.
     */
    public MongoRoleDefinitionGetResultsInner withPrivileges(List<Privilege> privileges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withPrivileges(privileges);
        return this;
    }

    /**
     * Get the roles property: The set of roles inherited by this Role Definition.
     *
     * @return the roles value.
     */
    public List<Role> roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The set of roles inherited by this Role Definition.
     *
     * @param roles the roles value to set.
     * @return the MongoRoleDefinitionGetResultsInner object itself.
     */
    public MongoRoleDefinitionGetResultsInner withRoles(List<Role> roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MongoRoleDefinitionResource();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
