/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class CommandPostBody {
    @JsonProperty(value="command", required=true)
    private String command;
    @JsonProperty(value="arguments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> arguments;
    @JsonProperty(value="host", required=true)
    private String host;
    @JsonProperty(value="cassandra-stop-start")
    private Boolean cassandraStopStart;
    @JsonProperty(value="readwrite")
    private Boolean readwrite;
    private static final ClientLogger LOGGER = new ClientLogger(CommandPostBody.class);

    public String command() {
        return this.command;
    }

    public CommandPostBody withCommand(String command) {
        this.command = command;
        return this;
    }

    public Map<String, String> arguments() {
        return this.arguments;
    }

    public CommandPostBody withArguments(Map<String, String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public String host() {
        return this.host;
    }

    public CommandPostBody withHost(String host) {
        this.host = host;
        return this;
    }

    public Boolean cassandraStopStart() {
        return this.cassandraStopStart;
    }

    public CommandPostBody withCassandraStopStart(Boolean cassandraStopStart) {
        this.cassandraStopStart = cassandraStopStart;
        return this;
    }

    public Boolean readwrite() {
        return this.readwrite;
    }

    public CommandPostBody withReadwrite(Boolean readwrite) {
        this.readwrite = readwrite;
        return this;
    }

    public void validate() {
        if (this.command() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property command in model CommandPostBody"));
        }
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model CommandPostBody"));
        }
    }
}

