// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Parameters for Create or Update request for SqlDedicatedGatewayServiceResource.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "serviceType",
    defaultImpl = SqlDedicatedGatewayServiceResourceCreateUpdateParameters.class,
    visible = true)
@JsonTypeName("SqlDedicatedGateway")
@Fluent
public final class SqlDedicatedGatewayServiceResourceCreateUpdateParameters
    extends ServiceResourceCreateUpdateProperties {
    /*
     * ServiceType for the service.
     */
    @JsonTypeId
    @JsonProperty(value = "serviceType", required = true)
    private ServiceType serviceType = ServiceType.SQL_DEDICATED_GATEWAY;

    /*
     * DedicatedGatewayType for the service.
     */
    @JsonProperty(value = "dedicatedGatewayType")
    private DedicatedGatewayType dedicatedGatewayType;

    /**
     * Creates an instance of SqlDedicatedGatewayServiceResourceCreateUpdateParameters class.
     */
    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters() {
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    @Override
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * Get the dedicatedGatewayType property: DedicatedGatewayType for the service.
     * 
     * @return the dedicatedGatewayType value.
     */
    public DedicatedGatewayType dedicatedGatewayType() {
        return this.dedicatedGatewayType;
    }

    /**
     * Set the dedicatedGatewayType property: DedicatedGatewayType for the service.
     * 
     * @param dedicatedGatewayType the dedicatedGatewayType value to set.
     * @return the SqlDedicatedGatewayServiceResourceCreateUpdateParameters object itself.
     */
    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters
        withDedicatedGatewayType(DedicatedGatewayType dedicatedGatewayType) {
        this.dedicatedGatewayType = dedicatedGatewayType;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters withInstanceSize(ServiceSize instanceSize) {
        super.withInstanceSize(instanceSize);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SqlDedicatedGatewayServiceResourceCreateUpdateParameters withInstanceCount(Integer instanceCount) {
        super.withInstanceCount(instanceCount);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
