// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Properties in ServiceResourceCreateUpdateParameters.
 */
@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    property = "serviceType",
    defaultImpl = ServiceResourceCreateUpdateProperties.class,
    visible = true)
@JsonTypeName("ServiceResourceCreateUpdateProperties")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "DataTransfer", value = DataTransferServiceResourceCreateUpdateParameters.class),
    @JsonSubTypes.Type(
        name = "SqlDedicatedGateway",
        value = SqlDedicatedGatewayServiceResourceCreateUpdateParameters.class),
    @JsonSubTypes.Type(name = "GraphAPICompute", value = GraphApiComputeServiceResourceCreateUpdateParameters.class),
    @JsonSubTypes.Type(
        name = "MaterializedViewsBuilder",
        value = MaterializedViewsBuilderServiceResourceCreateUpdateParameters.class) })
@Fluent
public class ServiceResourceCreateUpdateProperties {
    /*
     * ServiceType for the service.
     */
    @JsonTypeId
    @JsonProperty(value = "serviceType", required = true)
    private ServiceType serviceType;

    /*
     * Instance type for the service.
     */
    @JsonProperty(value = "instanceSize")
    private ServiceSize instanceSize;

    /*
     * Instance count for the service.
     */
    @JsonProperty(value = "instanceCount")
    private Integer instanceCount;

    /**
     * Creates an instance of ServiceResourceCreateUpdateProperties class.
     */
    public ServiceResourceCreateUpdateProperties() {
        this.serviceType = ServiceType.fromString("ServiceResourceCreateUpdateProperties");
    }

    /**
     * Get the serviceType property: ServiceType for the service.
     * 
     * @return the serviceType value.
     */
    public ServiceType serviceType() {
        return this.serviceType;
    }

    /**
     * Get the instanceSize property: Instance type for the service.
     * 
     * @return the instanceSize value.
     */
    public ServiceSize instanceSize() {
        return this.instanceSize;
    }

    /**
     * Set the instanceSize property: Instance type for the service.
     * 
     * @param instanceSize the instanceSize value to set.
     * @return the ServiceResourceCreateUpdateProperties object itself.
     */
    public ServiceResourceCreateUpdateProperties withInstanceSize(ServiceSize instanceSize) {
        this.instanceSize = instanceSize;
        return this;
    }

    /**
     * Get the instanceCount property: Instance count for the service.
     * 
     * @return the instanceCount value.
     */
    public Integer instanceCount() {
        return this.instanceCount;
    }

    /**
     * Set the instanceCount property: Instance count for the service.
     * 
     * @param instanceCount the instanceCount value to set.
     * @return the ServiceResourceCreateUpdateProperties object itself.
     */
    public ServiceResourceCreateUpdateProperties withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
