// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.fluent.models.ClusterResourceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * List of managed Cassandra clusters.
 */
@Fluent
public final class ListClusters {
    /*
     * Container for the array of clusters.
     */
    @JsonProperty(value = "value")
    private List<ClusterResourceInner> value;

    /**
     * Creates an instance of ListClusters class.
     */
    public ListClusters() {
    }

    /**
     * Get the value property: Container for the array of clusters.
     * 
     * @return the value value.
     */
    public List<ClusterResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Container for the array of clusters.
     * 
     * @param value the value value to set.
     * @return the ListClusters object itself.
     */
    public ListClusters withValue(List<ClusterResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
