// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Resource for a regional service location.
 */
@Immutable
public final class GraphApiComputeRegionalServiceResource extends RegionalServiceResource {
    /*
     * The regional endpoint for GraphAPICompute.
     */
    @JsonProperty(value = "graphApiComputeEndpoint", access = JsonProperty.Access.WRITE_ONLY)
    private String graphApiComputeEndpoint;

    /**
     * Creates an instance of GraphApiComputeRegionalServiceResource class.
     */
    public GraphApiComputeRegionalServiceResource() {
    }

    /**
     * Get the graphApiComputeEndpoint property: The regional endpoint for GraphAPICompute.
     * 
     * @return the graphApiComputeEndpoint value.
     */
    public String graphApiComputeEndpoint() {
        return this.graphApiComputeEndpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
