// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;

/**
 * DedicatedGatewayType for the service.
 */
public final class DedicatedGatewayType extends ExpandableStringEnum<DedicatedGatewayType> {
    /**
     * Static value IntegratedCache for DedicatedGatewayType.
     */
    public static final DedicatedGatewayType INTEGRATED_CACHE = fromString("IntegratedCache");

    /**
     * Static value DistributedQuery for DedicatedGatewayType.
     */
    public static final DedicatedGatewayType DISTRIBUTED_QUERY = fromString("DistributedQuery");

    /**
     * Creates a new instance of DedicatedGatewayType value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DedicatedGatewayType() {
    }

    /**
     * Creates or finds a DedicatedGatewayType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DedicatedGatewayType.
     */
    @JsonCreator
    public static DedicatedGatewayType fromString(String name) {
        return fromString(name, DedicatedGatewayType.class);
    }

    /**
     * Gets known DedicatedGatewayType values.
     *
     * @return known DedicatedGatewayType values.
     */
    public static Collection<DedicatedGatewayType> values() {
        return values(DedicatedGatewayType.class);
    }
}
