// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The definition of a computed property.
 */
@Fluent
public final class ComputedProperty {
    /*
     * The name of a computed property, for example - "cp_lowerName"
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The query that evaluates the value for computed property, for example - "SELECT VALUE LOWER(c.name) FROM c"
     */
    @JsonProperty(value = "query")
    private String query;

    /**
     * Creates an instance of ComputedProperty class.
     */
    public ComputedProperty() {
    }

    /**
     * Get the name property: The name of a computed property, for example - "cp_lowerName".
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of a computed property, for example - "cp_lowerName".
     * 
     * @param name the name value to set.
     * @return the ComputedProperty object itself.
     */
    public ComputedProperty withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the query property: The query that evaluates the value for computed property, for example - "SELECT VALUE
     * LOWER(c.name) FROM c".
     * 
     * @return the query value.
     */
    public String query() {
        return this.query;
    }

    /**
     * Set the query property: The query that evaluates the value for computed property, for example - "SELECT VALUE
     * LOWER(c.name) FROM c".
     * 
     * @param query the query value to set.
     * @return the ComputedProperty object itself.
     */
    public ComputedProperty withQuery(String query) {
        this.query = query;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
