// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * .
 */
@Fluent
public final class ClientEncryptionIncludedPath {
    /*
     * Path that needs to be encrypted.
     */
    @JsonProperty(value = "path", required = true)
    private String path;

    /*
     * The identifier of the Client Encryption Key to be used to encrypt the path.
     */
    @JsonProperty(value = "clientEncryptionKeyId", required = true)
    private String clientEncryptionKeyId;

    /*
     * The type of encryption to be performed. Eg - Deterministic, Randomized.
     */
    @JsonProperty(value = "encryptionType", required = true)
    private String encryptionType;

    /*
     * The encryption algorithm which will be used. Eg - AEAD_AES_256_CBC_HMAC_SHA256.
     */
    @JsonProperty(value = "encryptionAlgorithm", required = true)
    private String encryptionAlgorithm;

    /**
     * Creates an instance of ClientEncryptionIncludedPath class.
     */
    public ClientEncryptionIncludedPath() {
    }

    /**
     * Get the path property: Path that needs to be encrypted.
     * 
     * @return the path value.
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path property: Path that needs to be encrypted.
     * 
     * @param path the path value to set.
     * @return the ClientEncryptionIncludedPath object itself.
     */
    public ClientEncryptionIncludedPath withPath(String path) {
        this.path = path;
        return this;
    }

    /**
     * Get the clientEncryptionKeyId property: The identifier of the Client Encryption Key to be used to encrypt the
     * path.
     * 
     * @return the clientEncryptionKeyId value.
     */
    public String clientEncryptionKeyId() {
        return this.clientEncryptionKeyId;
    }

    /**
     * Set the clientEncryptionKeyId property: The identifier of the Client Encryption Key to be used to encrypt the
     * path.
     * 
     * @param clientEncryptionKeyId the clientEncryptionKeyId value to set.
     * @return the ClientEncryptionIncludedPath object itself.
     */
    public ClientEncryptionIncludedPath withClientEncryptionKeyId(String clientEncryptionKeyId) {
        this.clientEncryptionKeyId = clientEncryptionKeyId;
        return this;
    }

    /**
     * Get the encryptionType property: The type of encryption to be performed. Eg - Deterministic, Randomized.
     * 
     * @return the encryptionType value.
     */
    public String encryptionType() {
        return this.encryptionType;
    }

    /**
     * Set the encryptionType property: The type of encryption to be performed. Eg - Deterministic, Randomized.
     * 
     * @param encryptionType the encryptionType value to set.
     * @return the ClientEncryptionIncludedPath object itself.
     */
    public ClientEncryptionIncludedPath withEncryptionType(String encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    /**
     * Get the encryptionAlgorithm property: The encryption algorithm which will be used. Eg -
     * AEAD_AES_256_CBC_HMAC_SHA256.
     * 
     * @return the encryptionAlgorithm value.
     */
    public String encryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    /**
     * Set the encryptionAlgorithm property: The encryption algorithm which will be used. Eg -
     * AEAD_AES_256_CBC_HMAC_SHA256.
     * 
     * @param encryptionAlgorithm the encryptionAlgorithm value to set.
     * @return the ClientEncryptionIncludedPath object itself.
     */
    public ClientEncryptionIncludedPath withEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (path() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property path in model ClientEncryptionIncludedPath"));
        }
        if (clientEncryptionKeyId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property clientEncryptionKeyId in model ClientEncryptionIncludedPath"));
        }
        if (encryptionType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property encryptionType in model ClientEncryptionIncludedPath"));
        }
        if (encryptionAlgorithm() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property encryptionAlgorithm in model ClientEncryptionIncludedPath"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ClientEncryptionIncludedPath.class);
}
