// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.GremlinResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.BackupInformationInner;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinGraphGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.models.ContinuousBackupRestoreLocation;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseListResult;
import com.azure.resourcemanager.cosmos.models.GremlinGraphCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.GremlinGraphListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.nio.ByteBuffer;

/**
 * An instance of this class provides access to all the operations defined in GremlinResourcesClient.
 */
public final class GremlinResourcesClientImpl implements GremlinResourcesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GremlinResourcesService service;

    /**
     * The service client containing this operation class.
     */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of GremlinResourcesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    GremlinResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service
            = RestProxy.create(GremlinResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientGremlinResources to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementCl")
    public interface GremlinResourcesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinDatabaseListResult>> listGremlinDatabases(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabase(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabase(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabase(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughput(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToAutoscale(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToManualThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinGraphListResult>> listGremlinGraphs(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraph(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraph(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraph(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToAutoscale(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToManualThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/gremlinDatabases/{databaseName}/graphs/{graphName}/retrieveContinuousBackupInformation")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformation(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("graphName") String graphName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ContinuousBackupRestoreLocation location,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinDatabaseGetResultsInner>>
        listGremlinDatabasesSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listGremlinDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<GremlinDatabaseGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinDatabaseGetResultsInner>>
        listGremlinDatabasesSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listGremlinDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GremlinDatabaseGetResultsInner> listGremlinDatabasesAsync(String resourceGroupName,
        String accountName) {
        return new PagedFlux<>(() -> listGremlinDatabasesSinglePageAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GremlinDatabaseGetResultsInner> listGremlinDatabasesAsync(String resourceGroupName,
        String accountName, Context context) {
        return new PagedFlux<>(() -> listGremlinDatabasesSinglePageAsync(resourceGroupName, accountName, context));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinDatabaseGetResultsInner> listGremlinDatabases(String resourceGroupName,
        String accountName) {
        return new PagedIterable<>(listGremlinDatabasesAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the Gremlin databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the Gremlin databases and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinDatabaseGetResultsInner> listGremlinDatabases(String resourceGroupName,
        String accountName, Context context) {
        return new PagedIterable<>(listGremlinDatabasesAsync(resourceGroupName, accountName, context));
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GremlinDatabaseGetResultsInner>> getGremlinDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinDatabaseGetResultsInner> getGremlinDatabaseAsync(String resourceGroupName, String accountName,
        String databaseName) {
        return getGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GremlinDatabaseGetResultsInner> getGremlinDatabaseWithResponse(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return getGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinDatabaseGetResultsInner getGremlinDatabase(String resourceGroupName, String accountName,
        String databaseName) {
        return getGremlinDatabaseWithResponse(resourceGroupName, accountName, databaseName, Context.NONE).getValue();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateGremlinDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateGremlinDatabaseParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateGremlinDatabase(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), createUpdateGremlinDatabaseParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateGremlinDatabaseParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateGremlinDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateGremlinDatabaseParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(),
            createUpdateGremlinDatabaseParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateGremlinDatabaseWithResponseAsync(resourceGroupName,
            accountName, databaseName, createUpdateGremlinDatabaseParameters);
        return this.client.<GremlinDatabaseGetResultsInner, GremlinDatabaseGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), GremlinDatabaseGetResultsInner.class, GremlinDatabaseGetResultsInner.class,
            this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateGremlinDatabaseWithResponseAsync(resourceGroupName,
            accountName, databaseName, createUpdateGremlinDatabaseParameters, context);
        return this.client.<GremlinDatabaseGetResultsInner, GremlinDatabaseGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), GremlinDatabaseGetResultsInner.class, GremlinDatabaseGetResultsInner.class,
            context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return this
            .beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName,
                createUpdateGremlinDatabaseParameters)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GremlinDatabaseGetResultsInner>, GremlinDatabaseGetResultsInner>
        beginCreateUpdateGremlinDatabase(String resourceGroupName, String accountName, String databaseName,
            GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        return this
            .beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName,
                createUpdateGremlinDatabaseParameters, context)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(String resourceGroupName,
        String accountName, String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateGremlinDatabaseParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GremlinDatabaseGetResultsInner> createUpdateGremlinDatabaseAsync(String resourceGroupName,
        String accountName, String databaseName,
        GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters, Context context) {
        return beginCreateUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateGremlinDatabaseParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(String resourceGroupName, String accountName,
        String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters) {
        return createUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateGremlinDatabaseParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateGremlinDatabaseParameters The parameters to provide for the current Gremlin database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinDatabaseGetResultsInner createUpdateGremlinDatabase(String resourceGroupName, String accountName,
        String databaseName, GremlinDatabaseCreateUpdateParameters createUpdateGremlinDatabaseParameters,
        Context context) {
        return createUpdateGremlinDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateGremlinDatabaseParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context -> service.deleteGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteGremlinDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteGremlinDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteGremlinDatabaseAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteGremlinDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinDatabase(String resourceGroupName, String accountName,
        String databaseName) {
        return this.beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinDatabase(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return this.beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteGremlinDatabaseAsync(String resourceGroupName, String accountName, String databaseName,
        Context context) {
        return beginDeleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinDatabase(String resourceGroupName, String accountName, String databaseName,
        Context context) {
        deleteGremlinDatabaseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getGremlinDatabaseThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getGremlinDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputAsync(String resourceGroupName,
        String accountName, String databaseName) {
        return getGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getGremlinDatabaseThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return getGremlinDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context)
            .block();
    }

    /**
     * Gets the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the Gremlin database under an existing Azure Cosmos DB database account with the
     * provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getGremlinDatabaseThroughput(String resourceGroupName, String accountName,
        String databaseName) {
        return getGremlinDatabaseThroughputWithResponse(resourceGroupName, accountName, databaseName, Context.NONE)
            .getValue();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateGremlinDatabaseThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), updateThroughputParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateGremlinDatabaseThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateGremlinDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), updateThroughputParameters,
            accept, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateGremlinDatabaseThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, updateThroughputParameters);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateGremlinDatabaseThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, updateThroughputParameters, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this
            .beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
                updateThroughputParameters)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinDatabaseThroughput(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this
            .beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
                updateThroughputParameters, context)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateGremlinDatabaseThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return beginUpdateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters).block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin
     * database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinDatabaseThroughput(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateGremlinDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateGremlinDatabaseToAutoscale(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateGremlinDatabaseToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateGremlinDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateGremlinDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName,
            Context context) {
        return this.beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName) {
        return beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return beginMigrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToAutoscale(String resourceGroupName,
        String accountName, String databaseName) {
        return migrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToAutoscale(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return migrateGremlinDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateGremlinDatabaseToManualThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateGremlinDatabaseToManualThroughput(this.client.getEndpoint(),
            this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, this.client.getApiVersion(),
            accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateGremlinDatabaseToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = migrateGremlinDatabaseToManualThroughputWithResponseAsync(
            resourceGroupName, accountName, databaseName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToManualThroughput(String resourceGroupName, String accountName,
            String databaseName) {
        return this.beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName,
            Context context) {
        return this
            .beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinDatabaseToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginMigrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToManualThroughput(String resourceGroupName,
        String accountName, String databaseName) {
        return migrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinDatabaseToManualThroughput(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return migrateGremlinDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .block();
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinGraphGetResultsInner>> listGremlinGraphsSinglePageAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listGremlinGraphs(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<GremlinGraphGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GremlinGraphGetResultsInner>> listGremlinGraphsSinglePageAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listGremlinGraphs(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, databaseName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GremlinGraphGetResultsInner> listGremlinGraphsAsync(String resourceGroupName, String accountName,
        String databaseName) {
        return new PagedFlux<>(() -> listGremlinGraphsSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GremlinGraphGetResultsInner> listGremlinGraphsAsync(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return new PagedFlux<>(
            () -> listGremlinGraphsSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinGraphGetResultsInner> listGremlinGraphs(String resourceGroupName, String accountName,
        String databaseName) {
        return new PagedIterable<>(listGremlinGraphsAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the graphs and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GremlinGraphGetResultsInner> listGremlinGraphs(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return new PagedIterable<>(listGremlinGraphsAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraphWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GremlinGraphGetResultsInner>> getGremlinGraphWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, graphName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinGraphGetResultsInner> getGremlinGraphAsync(String resourceGroupName, String accountName,
        String databaseName, String graphName) {
        return getGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GremlinGraphGetResultsInner> getGremlinGraphWithResponse(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        return getGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .block();
    }

    /**
     * Gets the Gremlin graph under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinGraphGetResultsInner getGremlinGraph(String resourceGroupName, String accountName,
        String databaseName, String graphName) {
        return getGremlinGraphWithResponse(resourceGroupName, accountName, databaseName, graphName, Context.NONE)
            .getValue();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraphWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (createUpdateGremlinGraphParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateGremlinGraphParameters is required and cannot be null."));
        } else {
            createUpdateGremlinGraphParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateGremlinGraph(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName,
                this.client.getApiVersion(), createUpdateGremlinGraphParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateGremlinGraphWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (createUpdateGremlinGraphParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateGremlinGraphParameters is required and cannot be null."));
        } else {
            createUpdateGremlinGraphParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(),
            createUpdateGremlinGraphParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateGremlinGraphWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, createUpdateGremlinGraphParameters);
        return this.client.<GremlinGraphGetResultsInner, GremlinGraphGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), GremlinGraphGetResultsInner.class, GremlinGraphGetResultsInner.class,
            this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateGremlinGraphWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, createUpdateGremlinGraphParameters, context);
        return this.client.<GremlinGraphGetResultsInner, GremlinGraphGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), GremlinGraphGetResultsInner.class, GremlinGraphGetResultsInner.class,
            context);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName,
            String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return this
            .beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName,
                createUpdateGremlinGraphParameters)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GremlinGraphGetResultsInner>, GremlinGraphGetResultsInner>
        beginCreateUpdateGremlinGraph(String resourceGroupName, String accountName, String databaseName,
            String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        return this
            .beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName,
                createUpdateGremlinGraphParameters, context)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(String resourceGroupName, String accountName,
        String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName,
            createUpdateGremlinGraphParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GremlinGraphGetResultsInner> createUpdateGremlinGraphAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters, Context context) {
        return beginCreateUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName,
            createUpdateGremlinGraphParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinGraphGetResultsInner createUpdateGremlinGraph(String resourceGroupName, String accountName,
        String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters) {
        return createUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName,
            createUpdateGremlinGraphParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param createUpdateGremlinGraphParameters The parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Gremlin graph.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GremlinGraphGetResultsInner createUpdateGremlinGraph(String resourceGroupName, String accountName,
        String databaseName, String graphName, GremlinGraphCreateUpdateParameters createUpdateGremlinGraphParameters,
        Context context) {
        return createUpdateGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName,
            createUpdateGremlinGraphParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraphWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context -> service.deleteGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteGremlinGraphWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteGremlinGraph(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, graphName, this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteGremlinGraphAsync(String resourceGroupName, String accountName,
        String databaseName, String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteGremlinGraphAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteGremlinGraphWithResponseAsync(resourceGroupName, accountName, databaseName, graphName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinGraph(String resourceGroupName, String accountName,
        String databaseName, String graphName) {
        return this.beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteGremlinGraph(String resourceGroupName, String accountName,
        String databaseName, String graphName, Context context) {
        return this.beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName,
        String graphName) {
        return beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteGremlinGraphAsync(String resourceGroupName, String accountName, String databaseName,
        String graphName, Context context) {
        return beginDeleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName,
        String graphName) {
        deleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteGremlinGraph(String resourceGroupName, String accountName, String databaseName, String graphName,
        Context context) {
        deleteGremlinGraphAsync(resourceGroupName, accountName, databaseName, graphName, context).block();
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name
     * along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getGremlinGraphThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name
     * along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getGremlinGraphThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getGremlinGraphThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        return getGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name
     * along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getGremlinGraphThroughputWithResponse(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        return getGremlinGraphThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, graphName,
            context).block();
    }

    /**
     * Gets the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Gremlin graph throughput under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getGremlinGraphThroughput(String resourceGroupName, String accountName,
        String databaseName, String graphName) {
        return getGremlinGraphThroughputWithResponse(resourceGroupName, accountName, databaseName, graphName,
            Context.NONE).getValue();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateGremlinGraphThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName,
                this.client.getApiVersion(), updateThroughputParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateGremlinGraphThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateGremlinGraphThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(),
            updateThroughputParameters, accept, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateGremlinGraphThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, updateThroughputParameters);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateGremlinGraphThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, updateThroughputParameters, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName,
            String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this
            .beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
                updateThroughputParameters)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateGremlinGraphThroughput(String resourceGroupName, String accountName, String databaseName,
            String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this
            .beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
                updateThroughputParameters, context)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
            updateThroughputParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateGremlinGraphThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName,
        ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return beginUpdateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
            updateThroughputParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(String resourceGroupName, String accountName,
        String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
            updateThroughputParameters).block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB Gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current Gremlin graph.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateGremlinGraphThroughput(String resourceGroupName, String accountName,
        String databaseName, String graphName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateGremlinGraphThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
            updateThroughputParameters, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateGremlinGraphToAutoscale(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateGremlinGraphToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateGremlinGraphToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, graphName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = migrateGremlinGraphToAutoscaleWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToAutoscale(String resourceGroupName, String accountName, String databaseName,
            String graphName) {
        return this.beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToAutoscale(String resourceGroupName, String accountName, String databaseName,
            String graphName, Context context) {
        return this
            .beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        return beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        return beginMigrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToAutoscale(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        return migrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName).block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToAutoscale(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        return migrateGremlinGraphToAutoscaleAsync(resourceGroupName, accountName, databaseName, graphName, context)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateGremlinGraphToManualThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateGremlinGraphToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateGremlinGraphToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName, String graphName) {
        Mono<Response<Flux<ByteBuffer>>> mono = migrateGremlinGraphToManualThroughputWithResponseAsync(
            resourceGroupName, accountName, databaseName, graphName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName, String graphName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = migrateGremlinGraphToManualThroughputWithResponseAsync(
            resourceGroupName, accountName, databaseName, graphName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToManualThroughput(String resourceGroupName, String accountName, String databaseName,
            String graphName) {
        return this
            .beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateGremlinGraphToManualThroughput(String resourceGroupName, String accountName, String databaseName,
            String graphName, Context context) {
        return this
            .beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
                context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToManualThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        return beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateGremlinGraphToManualThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        return beginMigrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToManualThroughput(String resourceGroupName,
        String accountName, String databaseName, String graphName) {
        return migrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB Gremlin graph from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateGremlinGraphToManualThroughput(String resourceGroupName,
        String accountName, String databaseName, String graphName, Context context) {
        return migrateGremlinGraphToManualThroughputAsync(resourceGroupName, accountName, databaseName, graphName,
            context).block();
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName,
        ContinuousBackupRestoreLocation location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        } else {
            location.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.retrieveContinuousBackupInformation(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, graphName,
                this.client.getApiVersion(), location, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String graphName,
        ContinuousBackupRestoreLocation location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (graphName == null) {
            return Mono.error(new IllegalArgumentException("Parameter graphName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        } else {
            location.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.retrieveContinuousBackupInformation(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, graphName, this.client.getApiVersion(), location, accept,
            context);
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, ContinuousBackupRestoreLocation location) {
        Mono<Response<Flux<ByteBuffer>>> mono = retrieveContinuousBackupInformationWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, location);
        return this.client.<BackupInformationInner, BackupInformationInner>getLroResult(mono,
            this.client.getHttpPipeline(), BackupInformationInner.class, BackupInformationInner.class,
            this.client.getContext());
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(String resourceGroupName, String accountName, String databaseName,
            String graphName, ContinuousBackupRestoreLocation location, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = retrieveContinuousBackupInformationWithResponseAsync(resourceGroupName,
            accountName, databaseName, graphName, location, context);
        return this.client.<BackupInformationInner, BackupInformationInner>getLroResult(mono,
            this.client.getHttpPipeline(), BackupInformationInner.class, BackupInformationInner.class, context);
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformation(String resourceGroupName, String accountName, String databaseName,
            String graphName, ContinuousBackupRestoreLocation location) {
        return this
            .beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, graphName,
                location)
            .getSyncPoller();
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformation(String resourceGroupName, String accountName, String databaseName,
            String graphName, ContinuousBackupRestoreLocation location, Context context) {
        return this
            .beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, graphName,
                location, context)
            .getSyncPoller();
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, ContinuousBackupRestoreLocation location) {
        return beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, graphName,
            location).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(String resourceGroupName,
        String accountName, String databaseName, String graphName, ContinuousBackupRestoreLocation location,
        Context context) {
        return beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, graphName,
            location, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupInformationInner retrieveContinuousBackupInformation(String resourceGroupName, String accountName,
        String databaseName, String graphName, ContinuousBackupRestoreLocation location) {
        return retrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, graphName,
            location).block();
    }

    /**
     * Retrieves continuous backup information for a gremlin graph.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param graphName Cosmos DB graph name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupInformationInner retrieveContinuousBackupInformation(String resourceGroupName, String accountName,
        String databaseName, String graphName, ContinuousBackupRestoreLocation location, Context context) {
        return retrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, graphName,
            location, context).block();
    }
}
