// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ApiType;
import com.azure.resourcemanager.cosmos.models.RestorableLocationResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The properties of a restorable database account.
 */
@Fluent
public final class RestorableDatabaseAccountProperties {
    /*
     * The name of the global database account
     */
    @JsonProperty(value = "accountName")
    private String accountName;

    /*
     * The creation time of the restorable database account (ISO-8601 format).
     */
    @JsonProperty(value = "creationTime")
    private OffsetDateTime creationTime;

    /*
     * The time at which the restorable database account has been deleted (ISO-8601 format).
     */
    @JsonProperty(value = "deletionTime")
    private OffsetDateTime deletionTime;

    /*
     * The least recent time at which the database account can be restored to (ISO-8601 format).
     */
    @JsonProperty(value = "oldestRestorableTime")
    private OffsetDateTime oldestRestorableTime;

    /*
     * The API type of the restorable database account.
     */
    @JsonProperty(value = "apiType", access = JsonProperty.Access.WRITE_ONLY)
    private ApiType apiType;

    /*
     * List of regions where the of the database account can be restored from.
     */
    @JsonProperty(value = "restorableLocations", access = JsonProperty.Access.WRITE_ONLY)
    private List<RestorableLocationResource> restorableLocations;

    /**
     * Creates an instance of RestorableDatabaseAccountProperties class.
     */
    public RestorableDatabaseAccountProperties() {
    }

    /**
     * Get the accountName property: The name of the global database account.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The name of the global database account.
     * 
     * @param accountName the accountName value to set.
     * @return the RestorableDatabaseAccountProperties object itself.
     */
    public RestorableDatabaseAccountProperties withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the creationTime property: The creation time of the restorable database account (ISO-8601 format).
     * 
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Set the creationTime property: The creation time of the restorable database account (ISO-8601 format).
     * 
     * @param creationTime the creationTime value to set.
     * @return the RestorableDatabaseAccountProperties object itself.
     */
    public RestorableDatabaseAccountProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    /**
     * Get the deletionTime property: The time at which the restorable database account has been deleted (ISO-8601
     * format).
     * 
     * @return the deletionTime value.
     */
    public OffsetDateTime deletionTime() {
        return this.deletionTime;
    }

    /**
     * Set the deletionTime property: The time at which the restorable database account has been deleted (ISO-8601
     * format).
     * 
     * @param deletionTime the deletionTime value to set.
     * @return the RestorableDatabaseAccountProperties object itself.
     */
    public RestorableDatabaseAccountProperties withDeletionTime(OffsetDateTime deletionTime) {
        this.deletionTime = deletionTime;
        return this;
    }

    /**
     * Get the oldestRestorableTime property: The least recent time at which the database account can be restored to
     * (ISO-8601 format).
     * 
     * @return the oldestRestorableTime value.
     */
    public OffsetDateTime oldestRestorableTime() {
        return this.oldestRestorableTime;
    }

    /**
     * Set the oldestRestorableTime property: The least recent time at which the database account can be restored to
     * (ISO-8601 format).
     * 
     * @param oldestRestorableTime the oldestRestorableTime value to set.
     * @return the RestorableDatabaseAccountProperties object itself.
     */
    public RestorableDatabaseAccountProperties withOldestRestorableTime(OffsetDateTime oldestRestorableTime) {
        this.oldestRestorableTime = oldestRestorableTime;
        return this;
    }

    /**
     * Get the apiType property: The API type of the restorable database account.
     * 
     * @return the apiType value.
     */
    public ApiType apiType() {
        return this.apiType;
    }

    /**
     * Get the restorableLocations property: List of regions where the of the database account can be restored from.
     * 
     * @return the restorableLocations value.
     */
    public List<RestorableLocationResource> restorableLocations() {
        return this.restorableLocations;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (restorableLocations() != null) {
            restorableLocations().forEach(e -> e.validate());
        }
    }
}
