// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.fluent.models.NotebookWorkspaceInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A list of notebook workspace resources.
 */
@Fluent
public final class NotebookWorkspaceListResult {
    /*
     * Array of notebook workspace resources
     */
    @JsonProperty(value = "value")
    private List<NotebookWorkspaceInner> value;

    /**
     * Creates an instance of NotebookWorkspaceListResult class.
     */
    public NotebookWorkspaceListResult() {
    }

    /**
     * Get the value property: Array of notebook workspace resources.
     * 
     * @return the value value.
     */
    public List<NotebookWorkspaceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Array of notebook workspace resources.
     * 
     * @param value the value value to set.
     * @return the NotebookWorkspaceListResult object itself.
     */
    public NotebookWorkspaceListResult withValue(List<NotebookWorkspaceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
