// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Connection string for the Cosmos DB account.
 */
@Immutable
public final class DatabaseAccountConnectionString {
    /*
     * Value of the connection string
     */
    @JsonProperty(value = "connectionString", access = JsonProperty.Access.WRITE_ONLY)
    private String connectionString;

    /*
     * Description of the connection string
     */
    @JsonProperty(value = "description", access = JsonProperty.Access.WRITE_ONLY)
    private String description;

    /*
     * Kind of the connection string key
     */
    @JsonProperty(value = "keyKind", access = JsonProperty.Access.WRITE_ONLY)
    private Kind keyKind;

    /*
     * Type of the connection string
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private Type type;

    /**
     * Creates an instance of DatabaseAccountConnectionString class.
     */
    public DatabaseAccountConnectionString() {
    }

    /**
     * Get the connectionString property: Value of the connection string.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Get the description property: Description of the connection string.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the keyKind property: Kind of the connection string key.
     * 
     * @return the keyKind value.
     */
    public Kind keyKind() {
        return this.keyKind;
    }

    /**
     * Get the type property: Type of the connection string.
     * 
     * @return the type value.
     */
    public Type type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
