// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * Enum to indicate type of Continuous backup tier.
 */
public final class ContinuousTier extends ExpandableStringEnum<ContinuousTier> {
    /**
     * Static value Continuous7Days for ContinuousTier.
     */
    public static final ContinuousTier CONTINUOUS7DAYS = fromString("Continuous7Days");

    /**
     * Static value Continuous30Days for ContinuousTier.
     */
    public static final ContinuousTier CONTINUOUS30DAYS = fromString("Continuous30Days");

    /**
     * Creates a new instance of ContinuousTier value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ContinuousTier() {
    }

    /**
     * Creates or finds a ContinuousTier from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ContinuousTier.
     */
    @JsonCreator
    public static ContinuousTier fromString(String name) {
        return fromString(name, ContinuousTier.class);
    }

    /**
     * Gets known ContinuousTier values.
     * 
     * @return known ContinuousTier values.
     */
    public static Collection<ContinuousTier> values() {
        return values(ContinuousTier.class);
    }
}
