// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.SqlResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.BackupInformationInner;
import com.azure.resourcemanager.cosmos.fluent.models.ClientEncryptionKeyGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlContainerGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleAssignmentGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleDefinitionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlStoredProcedureGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlTriggerGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.SqlUserDefinedFunctionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionKeyCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionKeysListResult;
import com.azure.resourcemanager.cosmos.models.ContinuousBackupRestoreLocation;
import com.azure.resourcemanager.cosmos.models.SqlContainerCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlContainerListResult;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseListResult;
import com.azure.resourcemanager.cosmos.models.SqlRoleAssignmentCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlRoleAssignmentListResult;
import com.azure.resourcemanager.cosmos.models.SqlRoleDefinitionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlRoleDefinitionListResult;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlStoredProcedureListResult;
import com.azure.resourcemanager.cosmos.models.SqlTriggerCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlTriggerListResult;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.SqlUserDefinedFunctionListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in SqlResourcesClient.
 */
public final class SqlResourcesClientImpl implements SqlResourcesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final SqlResourcesService service;

    /**
     * The service client containing this operation class.
     */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of SqlResourcesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    SqlResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service
            = RestProxy.create(SqlResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientSqlResources to be used by the proxy service
     * to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementCl")
    public interface SqlResourcesService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlDatabaseListResult>> listSqlDatabases(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabase(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabase(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabase(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToAutoscale(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToManualThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlContainerListResult>> listSqlContainers(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlContainerGetResultsInner>> getSqlContainer(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainer(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlContainer(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToAutoscale(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToManualThroughput(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/clientEncryptionKeys")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ClientEncryptionKeysListResult>> listClientEncryptionKeys(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/clientEncryptionKeys/{clientEncryptionKeyName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ClientEncryptionKeyGetResultsInner>> getClientEncryptionKey(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("clientEncryptionKeyName") String clientEncryptionKeyName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/clientEncryptionKeys/{clientEncryptionKeyName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateClientEncryptionKey(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("clientEncryptionKeyName") String clientEncryptionKeyName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlStoredProcedureListResult>> listSqlStoredProcedures(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedure(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("storedProcedureName") String storedProcedureName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedure(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("storedProcedureName") String storedProcedureName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedure(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("storedProcedureName") String storedProcedureName, @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlUserDefinedFunctionListResult>> listSqlUserDefinedFunctions(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunction(
            @HostParam("$host") String endpoint, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("userDefinedFunctionName") String userDefinedFunctionName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunction(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("userDefinedFunctionName") String userDefinedFunctionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunction(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("userDefinedFunctionName") String userDefinedFunctionName,
            @QueryParam("api-version") String apiVersion, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlTriggerListResult>> listSqlTriggers(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlTriggerGetResultsInner>> getSqlTrigger(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("triggerName") String triggerName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTrigger(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("triggerName") String triggerName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Accept: application/json;q=0.9", "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlTrigger(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @PathParam("triggerName") String triggerName, @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlRoleDefinitionGetResultsInner>> getSqlRoleDefinition(@HostParam("$host") String endpoint,
            @PathParam("roleDefinitionId") String roleDefinitionId, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleDefinition(@HostParam("$host") String endpoint,
            @PathParam("roleDefinitionId") String roleDefinitionId, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions/{roleDefinitionId}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleDefinition(@HostParam("$host") String endpoint,
            @PathParam("roleDefinitionId") String roleDefinitionId, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleDefinitions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlRoleDefinitionListResult>> listSqlRoleDefinitions(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlRoleAssignmentGetResultsInner>> getSqlRoleAssignment(@HostParam("$host") String endpoint,
            @PathParam("roleAssignmentId") String roleAssignmentId, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleAssignment(@HostParam("$host") String endpoint,
            @PathParam("roleAssignmentId") String roleAssignmentId, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments/{roleAssignmentId}")
        @ExpectedResponses({ 200, 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleAssignment(@HostParam("$host") String endpoint,
            @PathParam("roleAssignmentId") String roleAssignmentId, @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlRoleAssignments")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SqlRoleAssignmentListResult>> listSqlRoleAssignments(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/retrieveContinuousBackupInformation")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformation(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName, @PathParam("containerName") String containerName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ContinuousBackupRestoreLocation location,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlDatabaseGetResultsInner>> listSqlDatabasesSinglePageAsync(String resourceGroupName,
        String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSqlDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<SqlDatabaseGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlDatabaseGetResultsInner>> listSqlDatabasesSinglePageAsync(String resourceGroupName,
        String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlDatabases(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties as paginated response
     * with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlDatabaseGetResultsInner> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return new PagedFlux<>(() -> listSqlDatabasesSinglePageAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties as paginated response
     * with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlDatabaseGetResultsInner> listSqlDatabasesAsync(String resourceGroupName, String accountName,
        Context context) {
        return new PagedFlux<>(() -> listSqlDatabasesSinglePageAsync(resourceGroupName, accountName, context));
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return new PagedIterable<>(listSqlDatabasesAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the SQL databases under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the SQL databases and their properties as paginated response
     * with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName,
        Context context) {
        return new PagedIterable<>(listSqlDatabasesAsync(resourceGroupName, accountName, context));
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlDatabaseGetResultsInner>> getSqlDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(String resourceGroupName, String accountName,
        String databaseName) {
        return getSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlDatabaseGetResultsInner> getSqlDatabaseWithResponse(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return getSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the SQL database under an existing Azure Cosmos DB database account with the provided name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL database under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlDatabaseGetResultsInner getSqlDatabase(String resourceGroupName, String accountName,
        String databaseName) {
        return getSqlDatabaseWithResponse(resourceGroupName, accountName, databaseName, Context.NONE).getValue();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateSqlDatabaseParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateSqlDatabaseParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlDatabase(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), createUpdateSqlDatabaseParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateSqlDatabaseParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateSqlDatabaseParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(),
            createUpdateSqlDatabaseParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>
        beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName,
            SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlDatabaseWithResponseAsync(resourceGroupName, accountName,
            databaseName, createUpdateSqlDatabaseParameters);
        return this.client.<SqlDatabaseGetResultsInner, SqlDatabaseGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlDatabaseGetResultsInner.class, SqlDatabaseGetResultsInner.class,
            this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>
        beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName,
            SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlDatabaseWithResponseAsync(resourceGroupName, accountName,
            databaseName, createUpdateSqlDatabaseParameters, context);
        return this.client.<SqlDatabaseGetResultsInner, SqlDatabaseGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlDatabaseGetResultsInner.class, SqlDatabaseGetResultsInner.class, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabase(
        String resourceGroupName, String accountName, String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateSqlDatabaseParameters).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabase(
        String resourceGroupName, String accountName, String databaseName,
        SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        return this.beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateSqlDatabaseParameters, context).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName,
        String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateSqlDatabaseParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName,
        String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        return beginCreateUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateSqlDatabaseParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlDatabaseGetResultsInner createUpdateSqlDatabase(String resourceGroupName, String accountName,
        String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return createUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateSqlDatabaseParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateSqlDatabaseParameters The parameters to provide for the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlDatabaseGetResultsInner createUpdateSqlDatabase(String resourceGroupName, String accountName,
        String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, Context context) {
        return createUpdateSqlDatabaseAsync(resourceGroupName, accountName, databaseName,
            createUpdateSqlDatabaseParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context -> service.deleteSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlDatabaseWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteSqlDatabase(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName,
        String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlDatabase(String resourceGroupName, String accountName,
        String databaseName) {
        return this.beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlDatabase(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return this.beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName,
        Context context) {
        return beginDeleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName, Context context) {
        deleteSqlDatabaseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     * provided name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>>
        getSqlDatabaseThroughputWithResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.getSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     * provided name along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     * provided name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(String resourceGroupName,
        String accountName, String databaseName) {
        return getSqlDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     * provided name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputWithResponse(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return getSqlDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the provided
     * name.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL database under an existing Azure Cosmos DB database account with the
     * provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getSqlDatabaseThroughput(String resourceGroupName, String accountName,
        String databaseName) {
        return getSqlDatabaseThroughputWithResponse(resourceGroupName, accountName, databaseName, Context.NONE)
            .getValue();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateSqlDatabaseThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), updateThroughputParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateSqlDatabaseThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateSqlDatabaseThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), updateThroughputParameters,
            accept, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateSqlDatabaseThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, updateThroughputParameters);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateSqlDatabaseThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, updateThroughputParameters, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters).getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters, context).getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return beginUpdateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName,
        String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters).block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName,
        String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return updateSqlDatabaseThroughputAsync(resourceGroupName, accountName, databaseName,
            updateThroughputParameters, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateSqlDatabaseToAutoscale(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateSqlDatabaseToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateSqlDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateSqlDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateSqlDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName,
            Context context) {
        return this.beginMigrateSqlDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateSqlDatabaseToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName) {
        return beginMigrateSqlDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateSqlDatabaseToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return beginMigrateSqlDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlDatabaseToAutoscale(String resourceGroupName, String accountName,
        String databaseName) {
        return migrateSqlDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlDatabaseToAutoscale(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return migrateSqlDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateSqlDatabaseToManualThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateSqlDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateSqlDatabaseToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = migrateSqlDatabaseToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = migrateSqlDatabaseToManualThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName) {
        return this.beginMigrateSqlDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlDatabaseToManualThroughput(String resourceGroupName, String accountName, String databaseName,
            Context context) {
        return this
            .beginMigrateSqlDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateSqlDatabaseToManualThroughputAsync(String resourceGroupName,
        String accountName, String databaseName) {
        return beginMigrateSqlDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateSqlDatabaseToManualThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return beginMigrateSqlDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlDatabaseToManualThroughput(String resourceGroupName,
        String accountName, String databaseName) {
        return migrateSqlDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL database from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlDatabaseToManualThroughput(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return migrateSqlDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlContainerGetResultsInner>> listSqlContainersSinglePageAsync(String resourceGroupName,
        String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listSqlContainers(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<SqlContainerGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlContainerGetResultsInner>> listSqlContainersSinglePageAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlContainers(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, databaseName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlContainerGetResultsInner> listSqlContainersAsync(String resourceGroupName, String accountName,
        String databaseName) {
        return new PagedFlux<>(() -> listSqlContainersSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlContainerGetResultsInner> listSqlContainersAsync(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return new PagedFlux<>(
            () -> listSqlContainersSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlContainerGetResultsInner> listSqlContainers(String resourceGroupName, String accountName,
        String databaseName) {
        return new PagedIterable<>(listSqlContainersAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the containers and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlContainerGetResultsInner> listSqlContainers(String resourceGroupName, String accountName,
        String databaseName, Context context) {
        return new PagedIterable<>(listSqlContainersAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlContainerGetResultsInner>> getSqlContainerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlContainerGetResultsInner>> getSqlContainerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, containerName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlContainerGetResultsInner> getSqlContainerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        return getSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlContainerGetResultsInner> getSqlContainerWithResponse(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return getSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, context)
            .block();
    }

    /**
     * Gets the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlContainerGetResultsInner getSqlContainer(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        return getSqlContainerWithResponse(resourceGroupName, accountName, databaseName, containerName, Context.NONE)
            .getValue();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (createUpdateSqlContainerParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlContainerParameters is required and cannot be null."));
        } else {
            createUpdateSqlContainerParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlContainer(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), createUpdateSqlContainerParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlContainerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (createUpdateSqlContainerParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlContainerParameters is required and cannot be null."));
        } else {
            createUpdateSqlContainerParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(),
            createUpdateSqlContainerParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>
        beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlContainerWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, createUpdateSqlContainerParameters);
        return this.client.<SqlContainerGetResultsInner, SqlContainerGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlContainerGetResultsInner.class, SqlContainerGetResultsInner.class,
            this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>
        beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlContainerWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, createUpdateSqlContainerParameters, context);
        return this.client.<SqlContainerGetResultsInner, SqlContainerGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlContainerGetResultsInner.class, SqlContainerGetResultsInner.class,
            context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>
        beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName,
            String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName,
            createUpdateSqlContainerParameters).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>
        beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName,
            String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters,
            Context context) {
        return this.beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName,
            createUpdateSqlContainerParameters, context).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName,
            createUpdateSqlContainerParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        return beginCreateUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName,
            createUpdateSqlContainerParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlContainerGetResultsInner createUpdateSqlContainer(String resourceGroupName, String accountName,
        String databaseName, String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return createUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName,
            createUpdateSqlContainerParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param createUpdateSqlContainerParameters The parameters to provide for the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB container.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlContainerGetResultsInner createUpdateSqlContainer(String resourceGroupName, String accountName,
        String databaseName, String containerName,
        SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, Context context) {
        return createUpdateSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName,
            createUpdateSqlContainerParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlContainerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context -> service.deleteSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlContainerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteSqlContainer(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, containerName, this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlContainerAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlContainerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlContainer(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        return this.beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlContainer(String resourceGroupName, String accountName,
        String databaseName, String containerName, Context context) {
        return this.beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName,
        String containerName) {
        return beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName,
        String containerName, Context context) {
        return beginDeleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName,
        String containerName) {
        deleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName,
        String containerName, Context context) {
        deleteSqlContainerAsync(resourceGroupName, accountName, databaseName, containerName, context).block();
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlContainerThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlContainerThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return getSqlContainerThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, containerName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getSqlContainerThroughputWithResponse(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return getSqlContainerThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, containerName,
            context).block();
    }

    /**
     * Gets the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the SQL container under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getSqlContainerThroughput(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        return getSqlContainerThroughputWithResponse(resourceGroupName, accountName, databaseName, containerName,
            Context.NONE).getValue();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.updateSqlContainerThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), updateThroughputParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateSqlContainerThroughputWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.updateSqlContainerThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(),
            updateThroughputParameters, accept, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateSqlContainerThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, updateThroughputParameters);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateSqlContainerThroughputWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, updateThroughputParameters, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName,
            String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            updateThroughputParameters).getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName,
            String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return this.beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            updateThroughputParameters, context).getSyncPoller();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            updateThroughputParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName,
        ThroughputSettingsUpdateParameters updateThroughputParameters, Context context) {
        return beginUpdateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            updateThroughputParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateSqlContainerThroughput(String resourceGroupName, String accountName,
        String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            updateThroughputParameters).block();
    }

    /**
     * Update RUs per second of an Azure Cosmos DB SQL container.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param updateThroughputParameters The parameters to provide for the RUs per second of the current SQL container.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateSqlContainerThroughput(String resourceGroupName, String accountName,
        String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateSqlContainerThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            updateThroughputParameters, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateSqlContainerToAutoscale(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToAutoscaleWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateSqlContainerToAutoscale(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = migrateSqlContainerToAutoscaleWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = migrateSqlContainerToAutoscaleWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscale(String resourceGroupName, String accountName, String databaseName,
            String containerName) {
        return this
            .beginMigrateSqlContainerToAutoscaleAsync(resourceGroupName, accountName, databaseName, containerName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToAutoscale(String resourceGroupName, String accountName, String databaseName,
            String containerName, Context context) {
        return this.beginMigrateSqlContainerToAutoscaleAsync(resourceGroupName, accountName, databaseName,
            containerName, context).getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateSqlContainerToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return beginMigrateSqlContainerToAutoscaleAsync(resourceGroupName, accountName, databaseName, containerName)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateSqlContainerToAutoscaleAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return beginMigrateSqlContainerToAutoscaleAsync(resourceGroupName, accountName, databaseName, containerName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlContainerToAutoscale(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return migrateSqlContainerToAutoscaleAsync(resourceGroupName, accountName, databaseName, containerName).block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from manual throughput to autoscale.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlContainerToAutoscale(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return migrateSqlContainerToAutoscaleAsync(resourceGroupName, accountName, databaseName, containerName, context)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.migrateSqlContainerToManualThroughput(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateSqlContainerToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.migrateSqlContainerToManualThroughput(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName, String containerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = migrateSqlContainerToManualThroughputWithResponseAsync(
            resourceGroupName, accountName, databaseName, containerName);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughputAsync(String resourceGroupName, String accountName,
            String databaseName, String containerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = migrateSqlContainerToManualThroughputWithResponseAsync(
            resourceGroupName, accountName, databaseName, containerName, context);
        return this.client.<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ThroughputSettingsGetResultsInner.class,
            ThroughputSettingsGetResultsInner.class, context);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughput(String resourceGroupName, String accountName, String databaseName,
            String containerName) {
        return this.beginMigrateSqlContainerToManualThroughputAsync(resourceGroupName, accountName, databaseName,
            containerName).getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateSqlContainerToManualThroughput(String resourceGroupName, String accountName, String databaseName,
            String containerName, Context context) {
        return this.beginMigrateSqlContainerToManualThroughputAsync(resourceGroupName, accountName, databaseName,
            containerName, context).getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateSqlContainerToManualThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return beginMigrateSqlContainerToManualThroughputAsync(resourceGroupName, accountName, databaseName,
            containerName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateSqlContainerToManualThroughputAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return beginMigrateSqlContainerToManualThroughputAsync(resourceGroupName, accountName, databaseName,
            containerName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlContainerToManualThroughput(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return migrateSqlContainerToManualThroughputAsync(resourceGroupName, accountName, databaseName, containerName)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB SQL container from autoscale to manual throughput.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateSqlContainerToManualThroughput(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return migrateSqlContainerToManualThroughputAsync(resourceGroupName, accountName, databaseName, containerName,
            context).block();
    }

    /**
     * Lists the ClientEncryptionKeys under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the client encryption keys and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ClientEncryptionKeyGetResultsInner>>
        listClientEncryptionKeysSinglePageAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listClientEncryptionKeys(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, databaseName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<ClientEncryptionKeyGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the ClientEncryptionKeys under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the client encryption keys and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ClientEncryptionKeyGetResultsInner>> listClientEncryptionKeysSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listClientEncryptionKeys(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, databaseName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the ClientEncryptionKeys under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the client encryption keys and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ClientEncryptionKeyGetResultsInner> listClientEncryptionKeysAsync(String resourceGroupName,
        String accountName, String databaseName) {
        return new PagedFlux<>(
            () -> listClientEncryptionKeysSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the ClientEncryptionKeys under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the client encryption keys and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ClientEncryptionKeyGetResultsInner> listClientEncryptionKeysAsync(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return new PagedFlux<>(
            () -> listClientEncryptionKeysSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Lists the ClientEncryptionKeys under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the client encryption keys and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ClientEncryptionKeyGetResultsInner> listClientEncryptionKeys(String resourceGroupName,
        String accountName, String databaseName) {
        return new PagedIterable<>(listClientEncryptionKeysAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the ClientEncryptionKeys under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the client encryption keys and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ClientEncryptionKeyGetResultsInner> listClientEncryptionKeys(String resourceGroupName,
        String accountName, String databaseName, Context context) {
        return new PagedIterable<>(
            listClientEncryptionKeysAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Gets the ClientEncryptionKey under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ClientEncryptionKey under an existing Azure Cosmos DB SQL database along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ClientEncryptionKeyGetResultsInner>> getClientEncryptionKeyWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String clientEncryptionKeyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (clientEncryptionKeyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter clientEncryptionKeyName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getClientEncryptionKey(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, clientEncryptionKeyName,
                this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the ClientEncryptionKey under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ClientEncryptionKey under an existing Azure Cosmos DB SQL database along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ClientEncryptionKeyGetResultsInner>> getClientEncryptionKeyWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String clientEncryptionKeyName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (clientEncryptionKeyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter clientEncryptionKeyName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getClientEncryptionKey(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, clientEncryptionKeyName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Gets the ClientEncryptionKey under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ClientEncryptionKey under an existing Azure Cosmos DB SQL database on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ClientEncryptionKeyGetResultsInner> getClientEncryptionKeyAsync(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName) {
        return getClientEncryptionKeyWithResponseAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the ClientEncryptionKey under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ClientEncryptionKey under an existing Azure Cosmos DB SQL database along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ClientEncryptionKeyGetResultsInner> getClientEncryptionKeyWithResponse(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName, Context context) {
        return getClientEncryptionKeyWithResponseAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, context).block();
    }

    /**
     * Gets the ClientEncryptionKey under an existing Azure Cosmos DB SQL database.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the ClientEncryptionKey under an existing Azure Cosmos DB SQL database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ClientEncryptionKeyGetResultsInner getClientEncryptionKey(String resourceGroupName, String accountName,
        String databaseName, String clientEncryptionKeyName) {
        return getClientEncryptionKeyWithResponse(resourceGroupName, accountName, databaseName, clientEncryptionKeyName,
            Context.NONE).getValue();
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return client Encryption Key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateClientEncryptionKeyWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName,
        ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (clientEncryptionKeyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter clientEncryptionKeyName is required and cannot be null."));
        }
        if (createUpdateClientEncryptionKeyParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateClientEncryptionKeyParameters is required and cannot be null."));
        } else {
            createUpdateClientEncryptionKeyParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateClientEncryptionKey(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, clientEncryptionKeyName,
                this.client.getApiVersion(), createUpdateClientEncryptionKeyParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return client Encryption Key along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateClientEncryptionKeyWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName,
        ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (clientEncryptionKeyName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter clientEncryptionKeyName is required and cannot be null."));
        }
        if (createUpdateClientEncryptionKeyParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateClientEncryptionKeyParameters is required and cannot be null."));
        } else {
            createUpdateClientEncryptionKeyParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateClientEncryptionKey(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, clientEncryptionKeyName, this.client.getApiVersion(),
            createUpdateClientEncryptionKeyParameters, accept, context);
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of client Encryption Key.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ClientEncryptionKeyGetResultsInner>, ClientEncryptionKeyGetResultsInner>
        beginCreateUpdateClientEncryptionKeyAsync(String resourceGroupName, String accountName, String databaseName,
            String clientEncryptionKeyName,
            ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateClientEncryptionKeyWithResponseAsync(resourceGroupName,
            accountName, databaseName, clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters);
        return this.client.<ClientEncryptionKeyGetResultsInner, ClientEncryptionKeyGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ClientEncryptionKeyGetResultsInner.class,
            ClientEncryptionKeyGetResultsInner.class, this.client.getContext());
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of client Encryption Key.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ClientEncryptionKeyGetResultsInner>, ClientEncryptionKeyGetResultsInner>
        beginCreateUpdateClientEncryptionKeyAsync(String resourceGroupName, String accountName, String databaseName,
            String clientEncryptionKeyName,
            ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateClientEncryptionKeyWithResponseAsync(resourceGroupName,
            accountName, databaseName, clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters, context);
        return this.client.<ClientEncryptionKeyGetResultsInner, ClientEncryptionKeyGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), ClientEncryptionKeyGetResultsInner.class,
            ClientEncryptionKeyGetResultsInner.class, context);
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of client Encryption Key.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClientEncryptionKeyGetResultsInner>, ClientEncryptionKeyGetResultsInner>
        beginCreateUpdateClientEncryptionKey(String resourceGroupName, String accountName, String databaseName,
            String clientEncryptionKeyName,
            ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters) {
        return this.beginCreateUpdateClientEncryptionKeyAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters).getSyncPoller();
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of client Encryption Key.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClientEncryptionKeyGetResultsInner>, ClientEncryptionKeyGetResultsInner>
        beginCreateUpdateClientEncryptionKey(String resourceGroupName, String accountName, String databaseName,
            String clientEncryptionKeyName,
            ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters, Context context) {
        return this.beginCreateUpdateClientEncryptionKeyAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters, context).getSyncPoller();
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return client Encryption Key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ClientEncryptionKeyGetResultsInner> createUpdateClientEncryptionKeyAsync(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName,
        ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters) {
        return beginCreateUpdateClientEncryptionKeyAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return client Encryption Key on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ClientEncryptionKeyGetResultsInner> createUpdateClientEncryptionKeyAsync(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName,
        ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters, Context context) {
        return beginCreateUpdateClientEncryptionKeyAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return client Encryption Key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ClientEncryptionKeyGetResultsInner createUpdateClientEncryptionKey(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName,
        ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters) {
        return createUpdateClientEncryptionKeyAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters).block();
    }

    /**
     * Create or update a ClientEncryptionKey. This API is meant to be invoked via tools such as the Azure Powershell
     * (instead of directly).
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param clientEncryptionKeyName Cosmos DB ClientEncryptionKey name.
     * @param createUpdateClientEncryptionKeyParameters The parameters to provide for the client encryption key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return client Encryption Key.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ClientEncryptionKeyGetResultsInner createUpdateClientEncryptionKey(String resourceGroupName,
        String accountName, String databaseName, String clientEncryptionKeyName,
        ClientEncryptionKeyCreateUpdateParameters createUpdateClientEncryptionKeyParameters, Context context) {
        return createUpdateClientEncryptionKeyAsync(resourceGroupName, accountName, databaseName,
            clientEncryptionKeyName, createUpdateClientEncryptionKeyParameters, context).block();
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSqlStoredProcedures(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<SqlStoredProcedureGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlStoredProcedures(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, databaseName, containerName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlStoredProcedureGetResultsInner> listSqlStoredProceduresAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return new PagedFlux<>(
            () -> listSqlStoredProceduresSinglePageAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlStoredProcedureGetResultsInner> listSqlStoredProceduresAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return new PagedFlux<>(() -> listSqlStoredProceduresSinglePageAsync(resourceGroupName, accountName,
            databaseName, containerName, context));
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return new PagedIterable<>(
            listSqlStoredProceduresAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    /**
     * Lists the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the storedProcedures and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return new PagedIterable<>(
            listSqlStoredProceduresAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String storedProcedureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlStoredProcedure(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                storedProcedureName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String storedProcedureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, storedProcedureName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName) {
        return getSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureWithResponse(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        return getSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, context).block();
    }

    /**
     * Gets the SQL storedProcedure under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL storedProcedure under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlStoredProcedureGetResultsInner getSqlStoredProcedure(String resourceGroupName, String accountName,
        String databaseName, String containerName, String storedProcedureName) {
        return getSqlStoredProcedureWithResponse(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, Context.NONE).getValue();
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedureWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null."));
        } else {
            createUpdateSqlStoredProcedureParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlStoredProcedure(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                storedProcedureName, this.client.getApiVersion(), createUpdateSqlStoredProcedureParameters, accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlStoredProcedureWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null."));
        } else {
            createUpdateSqlStoredProcedureParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, storedProcedureName,
            this.client.getApiVersion(), createUpdateSqlStoredProcedureParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlStoredProcedureWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters);
        return this.client.<SqlStoredProcedureGetResultsInner, SqlStoredProcedureGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlStoredProcedureGetResultsInner.class,
            SqlStoredProcedureGetResultsInner.class, this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createUpdateSqlStoredProcedureWithResponseAsync(resourceGroupName, accountName, databaseName,
                containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters, context);
        return this.client.<SqlStoredProcedureGetResultsInner, SqlStoredProcedureGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlStoredProcedureGetResultsInner.class,
            SqlStoredProcedureGetResultsInner.class, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName,
            String containerName, String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return this.beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName,
            containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>
        beginCreateUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName,
            String containerName, String storedProcedureName,
            SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        return this.beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName,
            containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters, context).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, createUpdateSqlStoredProcedureParameters).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        return beginCreateUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, createUpdateSqlStoredProcedureParameters, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return createUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, createUpdateSqlStoredProcedureParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param createUpdateSqlStoredProcedureParameters The parameters to provide for the current SQL storedProcedure.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB storedProcedure.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName,
        SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, Context context) {
        return createUpdateSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, createUpdateSqlStoredProcedureParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedureWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.deleteSqlStoredProcedure(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                storedProcedureName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlStoredProcedureWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (storedProcedureName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteSqlStoredProcedure(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, storedProcedureName,
            this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteSqlStoredProcedureWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, storedProcedureName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteSqlStoredProcedureWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, storedProcedureName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlStoredProcedure(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlStoredProcedure(String resourceGroupName,
        String accountName, String databaseName, String containerName, String storedProcedureName, Context context) {
        return this.beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName,
        String containerName, String storedProcedureName) {
        return beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName,
        String containerName, String storedProcedureName, Context context) {
        return beginDeleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName,
            storedProcedureName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName,
        String containerName, String storedProcedureName) {
        deleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName)
            .block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL storedProcedure.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param storedProcedureName Cosmos DB storedProcedure name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName,
        String containerName, String storedProcedureName, Context context) {
        deleteSqlStoredProcedureAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName,
            context).block();
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSqlUserDefinedFunctions(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), accept, context))
            .<PagedResponse<SqlUserDefinedFunctionGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlUserDefinedFunctions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, databaseName, containerName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctionsAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return new PagedFlux<>(() -> listSqlUserDefinedFunctionsSinglePageAsync(resourceGroupName, accountName,
            databaseName, containerName));
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties as paginated
     * response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctionsAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return new PagedFlux<>(() -> listSqlUserDefinedFunctionsSinglePageAsync(resourceGroupName, accountName,
            databaseName, containerName, context));
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        return new PagedIterable<>(
            listSqlUserDefinedFunctionsAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    /**
     * Lists the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the userDefinedFunctions and their properties as paginated
     * response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        return new PagedIterable<>(
            listSqlUserDefinedFunctionsAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String userDefinedFunctionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlUserDefinedFunction(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                userDefinedFunctionName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account along with
     * {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String userDefinedFunctionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName,
            this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return getSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account along with
     * {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionWithResponse(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String userDefinedFunctionName, Context context) {
        return getSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, context).block();
    }

    /**
     * Gets the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL userDefinedFunction under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlUserDefinedFunctionGetResultsInner getSqlUserDefinedFunction(String resourceGroupName, String accountName,
        String databaseName, String containerName, String userDefinedFunctionName) {
        return getSqlUserDefinedFunctionWithResponse(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, Context.NONE).getValue();
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null."));
        } else {
            createUpdateSqlUserDefinedFunctionParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlUserDefinedFunction(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                userDefinedFunctionName, this.client.getApiVersion(), createUpdateSqlUserDefinedFunctionParameters,
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlUserDefinedFunctionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null."));
        } else {
            createUpdateSqlUserDefinedFunctionParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName,
            this.client.getApiVersion(), createUpdateSqlUserDefinedFunctionParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createUpdateSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName,
                containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters);
        return this.client.<SqlUserDefinedFunctionGetResultsInner, SqlUserDefinedFunctionGetResultsInner>getLroResult(
            mono, this.client.getHttpPipeline(), SqlUserDefinedFunctionGetResultsInner.class,
            SqlUserDefinedFunctionGetResultsInner.class, this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createUpdateSqlUserDefinedFunctionWithResponseAsync(resourceGroupName, accountName, databaseName,
                containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context);
        return this.client.<SqlUserDefinedFunctionGetResultsInner, SqlUserDefinedFunctionGetResultsInner>getLroResult(
            mono, this.client.getHttpPipeline(), SqlUserDefinedFunctionGetResultsInner.class,
            SqlUserDefinedFunctionGetResultsInner.class, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName,
            String containerName, String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return this.beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName,
            containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>
        beginCreateUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName,
            String containerName, String userDefinedFunctionName,
            SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters,
            Context context) {
        return this.beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName,
            containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        return beginCreateUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return createUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param createUpdateSqlUserDefinedFunctionParameters The parameters to provide for the current SQL
     * userDefinedFunction.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB userDefinedFunction.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName,
        SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, Context context) {
        return createUpdateSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.deleteSqlUserDefinedFunction(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                userDefinedFunctionName, this.client.getApiVersion(), context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlUserDefinedFunctionWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (userDefinedFunctionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteSqlUserDefinedFunction(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName,
            this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteSqlUserDefinedFunctionWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, userDefinedFunctionName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteSqlUserDefinedFunctionWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, userDefinedFunctionName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunction(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlUserDefinedFunction(String resourceGroupName,
        String accountName, String databaseName, String containerName, String userDefinedFunctionName,
        Context context) {
        return this.beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String userDefinedFunctionName) {
        return beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String userDefinedFunctionName, Context context) {
        return beginDeleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName,
        String containerName, String userDefinedFunctionName) {
        deleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL userDefinedFunction.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param userDefinedFunctionName Cosmos DB userDefinedFunction name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName,
        String containerName, String userDefinedFunctionName, Context context) {
        deleteSqlUserDefinedFunctionAsync(resourceGroupName, accountName, databaseName, containerName,
            userDefinedFunctionName, context).block();
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlTriggerGetResultsInner>> listSqlTriggersSinglePageAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listSqlTriggers(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), accept,
                context))
            .<PagedResponse<SqlTriggerGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties along with
     * {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlTriggerGetResultsInner>> listSqlTriggersSinglePageAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlTriggers(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, accountName,
                databaseName, containerName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlTriggerGetResultsInner> listSqlTriggersAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        return new PagedFlux<>(
            () -> listSqlTriggersSinglePageAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlTriggerGetResultsInner> listSqlTriggersAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, Context context) {
        return new PagedFlux<>(
            () -> listSqlTriggersSinglePageAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlTriggerGetResultsInner> listSqlTriggers(String resourceGroupName, String accountName,
        String databaseName, String containerName) {
        return new PagedIterable<>(listSqlTriggersAsync(resourceGroupName, accountName, databaseName, containerName));
    }

    /**
     * Lists the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the triggers and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlTriggerGetResultsInner> listSqlTriggers(String resourceGroupName, String accountName,
        String databaseName, String containerName, Context context) {
        return new PagedIterable<>(
            listSqlTriggersAsync(resourceGroupName, accountName, databaseName, containerName, context));
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlTriggerGetResultsInner>> getSqlTriggerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, databaseName, containerName, triggerName, this.client.getApiVersion(),
                accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlTriggerGetResultsInner>> getSqlTriggerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, containerName, triggerName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlTriggerGetResultsInner> getSqlTriggerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName) {
        return getSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlTriggerGetResultsInner> getSqlTriggerWithResponse(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName, Context context) {
        return getSqlTriggerWithResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName,
            context).block();
    }

    /**
     * Gets the SQL trigger under an existing Azure Cosmos DB database account.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the SQL trigger under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlTriggerGetResultsInner getSqlTrigger(String resourceGroupName, String accountName, String databaseName,
        String containerName, String triggerName) {
        return getSqlTriggerWithResponse(resourceGroupName, accountName, databaseName, containerName, triggerName,
            Context.NONE).getValue();
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTriggerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (createUpdateSqlTriggerParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlTriggerParameters is required and cannot be null."));
        } else {
            createUpdateSqlTriggerParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlTrigger(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                triggerName, this.client.getApiVersion(), createUpdateSqlTriggerParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlTriggerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        if (createUpdateSqlTriggerParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlTriggerParameters is required and cannot be null."));
        } else {
            createUpdateSqlTriggerParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, triggerName, this.client.getApiVersion(),
            createUpdateSqlTriggerParameters, accept, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>
        beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, String triggerName,
            SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlTriggerWithResponseAsync(resourceGroupName, accountName,
            databaseName, containerName, triggerName, createUpdateSqlTriggerParameters);
        return this.client.<SqlTriggerGetResultsInner, SqlTriggerGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlTriggerGetResultsInner.class, SqlTriggerGetResultsInner.class,
            this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>
        beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlTriggerWithResponseAsync(resourceGroupName, accountName,
            databaseName, containerName, triggerName, createUpdateSqlTriggerParameters, context);
        return this.client.<SqlTriggerGetResultsInner, SqlTriggerGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlTriggerGetResultsInner.class, SqlTriggerGetResultsInner.class, context);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTrigger(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return this.beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName,
            triggerName, createUpdateSqlTriggerParameters).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner> beginCreateUpdateSqlTrigger(
        String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        return this.beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName,
            triggerName, createUpdateSqlTriggerParameters, context).getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName,
            triggerName, createUpdateSqlTriggerParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        return beginCreateUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName,
            triggerName, createUpdateSqlTriggerParameters, context).last()
                .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlTriggerGetResultsInner createUpdateSqlTrigger(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return createUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName,
            createUpdateSqlTriggerParameters).block();
    }

    /**
     * Create or update an Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param createUpdateSqlTriggerParameters The parameters to provide for the current SQL trigger.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB trigger.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlTriggerGetResultsInner createUpdateSqlTrigger(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName,
        SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, Context context) {
        return createUpdateSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName,
            createUpdateSqlTriggerParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlTriggerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(context -> service.deleteSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, accountName, databaseName, containerName, triggerName, this.client.getApiVersion(),
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlTriggerWithResponseAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, String triggerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (triggerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter triggerName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service.deleteSqlTrigger(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            accountName, databaseName, containerName, triggerName, this.client.getApiVersion(), context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteSqlTriggerWithResponseAsync(resourceGroupName, accountName,
            databaseName, containerName, triggerName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = deleteSqlTriggerWithResponseAsync(resourceGroupName, accountName,
            databaseName, containerName, triggerName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlTrigger(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName) {
        return this.beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlTrigger(String resourceGroupName, String accountName,
        String databaseName, String containerName, String triggerName, Context context) {
        return this.beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName,
            context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName,
        String containerName, String triggerName) {
        return beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName)
            .last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName,
        String containerName, String triggerName, Context context) {
        return beginDeleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName,
            context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlTrigger(String resourceGroupName, String accountName, String databaseName,
        String containerName, String triggerName) {
        deleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL trigger.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param triggerName Cosmos DB trigger name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlTrigger(String resourceGroupName, String accountName, String databaseName,
        String containerName, String triggerName, Context context) {
        deleteSqlTriggerAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, context)
            .block();
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlRoleDefinitionGetResultsInner>>
        getSqlRoleDefinitionWithResponseAsync(String roleDefinitionId, String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlRoleDefinition(this.client.getEndpoint(), roleDefinitionId,
                this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlRoleDefinitionGetResultsInner>> getSqlRoleDefinitionWithResponseAsync(
        String roleDefinitionId, String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlRoleDefinition(this.client.getEndpoint(), roleDefinitionId,
            this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlRoleDefinitionGetResultsInner> getSqlRoleDefinitionAsync(String roleDefinitionId,
        String resourceGroupName, String accountName) {
        return getSqlRoleDefinitionWithResponseAsync(roleDefinitionId, resourceGroupName, accountName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlRoleDefinitionGetResultsInner> getSqlRoleDefinitionWithResponse(String roleDefinitionId,
        String resourceGroupName, String accountName, Context context) {
        return getSqlRoleDefinitionWithResponseAsync(roleDefinitionId, resourceGroupName, accountName, context).block();
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Definition with the given Id.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlRoleDefinitionGetResultsInner getSqlRoleDefinition(String roleDefinitionId, String resourceGroupName,
        String accountName) {
        return getSqlRoleDefinitionWithResponse(roleDefinitionId, resourceGroupName, accountName, Context.NONE)
            .getValue();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleDefinitionWithResponseAsync(String roleDefinitionId,
        String resourceGroupName, String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (createUpdateSqlRoleDefinitionParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlRoleDefinitionParameters is required and cannot be null."));
        } else {
            createUpdateSqlRoleDefinitionParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlRoleDefinition(this.client.getEndpoint(), roleDefinitionId,
                this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(),
                createUpdateSqlRoleDefinitionParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleDefinitionWithResponseAsync(String roleDefinitionId,
        String resourceGroupName, String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (createUpdateSqlRoleDefinitionParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlRoleDefinitionParameters is required and cannot be null."));
        } else {
            createUpdateSqlRoleDefinitionParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlRoleDefinition(this.client.getEndpoint(), roleDefinitionId,
            this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(),
            createUpdateSqlRoleDefinitionParameters, accept, context);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinitionAsync(String roleDefinitionId, String resourceGroupName, String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlRoleDefinitionWithResponseAsync(roleDefinitionId,
            resourceGroupName, accountName, createUpdateSqlRoleDefinitionParameters);
        return this.client.<SqlRoleDefinitionGetResultsInner, SqlRoleDefinitionGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlRoleDefinitionGetResultsInner.class,
            SqlRoleDefinitionGetResultsInner.class, this.client.getContext());
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinitionAsync(String roleDefinitionId, String resourceGroupName, String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlRoleDefinitionWithResponseAsync(roleDefinitionId,
            resourceGroupName, accountName, createUpdateSqlRoleDefinitionParameters, context);
        return this.client.<SqlRoleDefinitionGetResultsInner, SqlRoleDefinitionGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlRoleDefinitionGetResultsInner.class,
            SqlRoleDefinitionGetResultsInner.class, context);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinition(String roleDefinitionId, String resourceGroupName, String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters) {
        return this.beginCreateUpdateSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName,
            createUpdateSqlRoleDefinitionParameters).getSyncPoller();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlRoleDefinitionGetResultsInner>, SqlRoleDefinitionGetResultsInner>
        beginCreateUpdateSqlRoleDefinition(String roleDefinitionId, String resourceGroupName, String accountName,
            SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters, Context context) {
        return this.beginCreateUpdateSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName,
            createUpdateSqlRoleDefinitionParameters, context).getSyncPoller();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlRoleDefinitionGetResultsInner> createUpdateSqlRoleDefinitionAsync(String roleDefinitionId,
        String resourceGroupName, String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters) {
        return beginCreateUpdateSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName,
            createUpdateSqlRoleDefinitionParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlRoleDefinitionGetResultsInner> createUpdateSqlRoleDefinitionAsync(String roleDefinitionId,
        String resourceGroupName, String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters, Context context) {
        return beginCreateUpdateSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName,
            createUpdateSqlRoleDefinitionParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlRoleDefinitionGetResultsInner createUpdateSqlRoleDefinition(String roleDefinitionId,
        String resourceGroupName, String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters) {
        return createUpdateSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName,
            createUpdateSqlRoleDefinitionParameters).block();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleDefinitionParameters The properties required to create or update a Role Definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB SQL Role Definition.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlRoleDefinitionGetResultsInner createUpdateSqlRoleDefinition(String roleDefinitionId,
        String resourceGroupName, String accountName,
        SqlRoleDefinitionCreateUpdateParameters createUpdateSqlRoleDefinitionParameters, Context context) {
        return createUpdateSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName,
            createUpdateSqlRoleDefinitionParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleDefinitionWithResponseAsync(String roleDefinitionId,
        String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteSqlRoleDefinition(this.client.getEndpoint(), roleDefinitionId,
                this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleDefinitionWithResponseAsync(String roleDefinitionId,
        String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleDefinitionId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleDefinitionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteSqlRoleDefinition(this.client.getEndpoint(), roleDefinitionId,
            this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlRoleDefinitionAsync(String roleDefinitionId,
        String resourceGroupName, String accountName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlRoleDefinitionWithResponseAsync(roleDefinitionId, resourceGroupName, accountName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlRoleDefinitionAsync(String roleDefinitionId,
        String resourceGroupName, String accountName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlRoleDefinitionWithResponseAsync(roleDefinitionId, resourceGroupName, accountName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleDefinition(String roleDefinitionId,
        String resourceGroupName, String accountName) {
        return this.beginDeleteSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleDefinition(String roleDefinitionId,
        String resourceGroupName, String accountName, Context context) {
        return this.beginDeleteSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlRoleDefinitionAsync(String roleDefinitionId, String resourceGroupName,
        String accountName) {
        return beginDeleteSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlRoleDefinitionAsync(String roleDefinitionId, String resourceGroupName,
        String accountName, Context context) {
        return beginDeleteSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlRoleDefinition(String roleDefinitionId, String resourceGroupName, String accountName) {
        deleteSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Definition.
     * 
     * @param roleDefinitionId The GUID for the Role Definition.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlRoleDefinition(String roleDefinitionId, String resourceGroupName, String accountName,
        Context context) {
        deleteSqlRoleDefinitionAsync(roleDefinitionId, resourceGroupName, accountName, context).block();
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlRoleDefinitionGetResultsInner>>
        listSqlRoleDefinitionsSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listSqlRoleDefinitions(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<SqlRoleDefinitionGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlRoleDefinitionGetResultsInner>>
        listSqlRoleDefinitionsSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlRoleDefinitions(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitionsAsync(String resourceGroupName,
        String accountName) {
        return new PagedFlux<>(() -> listSqlRoleDefinitionsSinglePageAsync(resourceGroupName, accountName));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitionsAsync(String resourceGroupName,
        String accountName, Context context) {
        return new PagedFlux<>(() -> listSqlRoleDefinitionsSinglePageAsync(resourceGroupName, accountName, context));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitions(String resourceGroupName,
        String accountName) {
        return new PagedIterable<>(listSqlRoleDefinitionsAsync(resourceGroupName, accountName));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Definitions.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Definitions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlRoleDefinitionGetResultsInner> listSqlRoleDefinitions(String resourceGroupName,
        String accountName, Context context) {
        return new PagedIterable<>(listSqlRoleDefinitionsAsync(resourceGroupName, accountName, context));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SqlRoleAssignmentGetResultsInner>>
        getSqlRoleAssignmentWithResponseAsync(String roleAssignmentId, String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getSqlRoleAssignment(this.client.getEndpoint(), roleAssignmentId,
                this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SqlRoleAssignmentGetResultsInner>> getSqlRoleAssignmentWithResponseAsync(
        String roleAssignmentId, String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getSqlRoleAssignment(this.client.getEndpoint(), roleAssignmentId,
            this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlRoleAssignmentGetResultsInner> getSqlRoleAssignmentAsync(String roleAssignmentId,
        String resourceGroupName, String accountName) {
        return getSqlRoleAssignmentWithResponseAsync(roleAssignmentId, resourceGroupName, accountName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SqlRoleAssignmentGetResultsInner> getSqlRoleAssignmentWithResponse(String roleAssignmentId,
        String resourceGroupName, String accountName, Context context) {
        return getSqlRoleAssignmentWithResponseAsync(roleAssignmentId, resourceGroupName, accountName, context).block();
    }

    /**
     * Retrieves the properties of an existing Azure Cosmos DB SQL Role Assignment with the given Id.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlRoleAssignmentGetResultsInner getSqlRoleAssignment(String roleAssignmentId, String resourceGroupName,
        String accountName) {
        return getSqlRoleAssignmentWithResponse(roleAssignmentId, resourceGroupName, accountName, Context.NONE)
            .getValue();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleAssignmentWithResponseAsync(String roleAssignmentId,
        String resourceGroupName, String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (createUpdateSqlRoleAssignmentParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlRoleAssignmentParameters is required and cannot be null."));
        } else {
            createUpdateSqlRoleAssignmentParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdateSqlRoleAssignment(this.client.getEndpoint(), roleAssignmentId,
                this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(),
                createUpdateSqlRoleAssignmentParameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateSqlRoleAssignmentWithResponseAsync(String roleAssignmentId,
        String resourceGroupName, String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (createUpdateSqlRoleAssignmentParameters == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter createUpdateSqlRoleAssignmentParameters is required and cannot be null."));
        } else {
            createUpdateSqlRoleAssignmentParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdateSqlRoleAssignment(this.client.getEndpoint(), roleAssignmentId,
            this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(),
            createUpdateSqlRoleAssignmentParameters, accept, context);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignmentAsync(String roleAssignmentId, String resourceGroupName, String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlRoleAssignmentWithResponseAsync(roleAssignmentId,
            resourceGroupName, accountName, createUpdateSqlRoleAssignmentParameters);
        return this.client.<SqlRoleAssignmentGetResultsInner, SqlRoleAssignmentGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlRoleAssignmentGetResultsInner.class,
            SqlRoleAssignmentGetResultsInner.class, this.client.getContext());
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignmentAsync(String roleAssignmentId, String resourceGroupName, String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createUpdateSqlRoleAssignmentWithResponseAsync(roleAssignmentId,
            resourceGroupName, accountName, createUpdateSqlRoleAssignmentParameters, context);
        return this.client.<SqlRoleAssignmentGetResultsInner, SqlRoleAssignmentGetResultsInner>getLroResult(mono,
            this.client.getHttpPipeline(), SqlRoleAssignmentGetResultsInner.class,
            SqlRoleAssignmentGetResultsInner.class, context);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignment(String roleAssignmentId, String resourceGroupName, String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters) {
        return this.beginCreateUpdateSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName,
            createUpdateSqlRoleAssignmentParameters).getSyncPoller();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SqlRoleAssignmentGetResultsInner>, SqlRoleAssignmentGetResultsInner>
        beginCreateUpdateSqlRoleAssignment(String roleAssignmentId, String resourceGroupName, String accountName,
            SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters, Context context) {
        return this.beginCreateUpdateSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName,
            createUpdateSqlRoleAssignmentParameters, context).getSyncPoller();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SqlRoleAssignmentGetResultsInner> createUpdateSqlRoleAssignmentAsync(String roleAssignmentId,
        String resourceGroupName, String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters) {
        return beginCreateUpdateSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName,
            createUpdateSqlRoleAssignmentParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SqlRoleAssignmentGetResultsInner> createUpdateSqlRoleAssignmentAsync(String roleAssignmentId,
        String resourceGroupName, String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters, Context context) {
        return beginCreateUpdateSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName,
            createUpdateSqlRoleAssignmentParameters, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlRoleAssignmentGetResultsInner createUpdateSqlRoleAssignment(String roleAssignmentId,
        String resourceGroupName, String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters) {
        return createUpdateSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName,
            createUpdateSqlRoleAssignmentParameters).block();
    }

    /**
     * Creates or updates an Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param createUpdateSqlRoleAssignmentParameters The properties required to create or update a Role Assignment.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB Role Assignment.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SqlRoleAssignmentGetResultsInner createUpdateSqlRoleAssignment(String roleAssignmentId,
        String resourceGroupName, String accountName,
        SqlRoleAssignmentCreateUpdateParameters createUpdateSqlRoleAssignmentParameters, Context context) {
        return createUpdateSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName,
            createUpdateSqlRoleAssignmentParameters, context).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleAssignmentWithResponseAsync(String roleAssignmentId,
        String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteSqlRoleAssignment(this.client.getEndpoint(), roleAssignmentId,
                this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
                context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteSqlRoleAssignmentWithResponseAsync(String roleAssignmentId,
        String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleAssignmentId == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleAssignmentId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteSqlRoleAssignment(this.client.getEndpoint(), roleAssignmentId,
            this.client.getSubscriptionId(), resourceGroupName, accountName, this.client.getApiVersion(), accept,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteSqlRoleAssignmentAsync(String roleAssignmentId,
        String resourceGroupName, String accountName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlRoleAssignmentWithResponseAsync(roleAssignmentId, resourceGroupName, accountName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteSqlRoleAssignmentAsync(String roleAssignmentId,
        String resourceGroupName, String accountName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteSqlRoleAssignmentWithResponseAsync(roleAssignmentId, resourceGroupName, accountName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleAssignment(String roleAssignmentId,
        String resourceGroupName, String accountName) {
        return this.beginDeleteSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteSqlRoleAssignment(String roleAssignmentId,
        String resourceGroupName, String accountName, Context context) {
        return this.beginDeleteSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteSqlRoleAssignmentAsync(String roleAssignmentId, String resourceGroupName,
        String accountName) {
        return beginDeleteSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteSqlRoleAssignmentAsync(String roleAssignmentId, String resourceGroupName,
        String accountName, Context context) {
        return beginDeleteSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlRoleAssignment(String roleAssignmentId, String resourceGroupName, String accountName) {
        deleteSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB SQL Role Assignment.
     * 
     * @param roleAssignmentId The GUID for the Role Assignment.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteSqlRoleAssignment(String roleAssignmentId, String resourceGroupName, String accountName,
        Context context) {
        deleteSqlRoleAssignmentAsync(roleAssignmentId, resourceGroupName, accountName, context).block();
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlRoleAssignmentGetResultsInner>>
        listSqlRoleAssignmentsSinglePageAsync(String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listSqlRoleAssignments(this.client.getEndpoint(), this.client.getSubscriptionId(),
                    resourceGroupName, accountName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<SqlRoleAssignmentGetResultsInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments along with {@link PagedResponse} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SqlRoleAssignmentGetResultsInner>>
        listSqlRoleAssignmentsSinglePageAsync(String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listSqlRoleAssignments(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
                accountName, this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignmentsAsync(String resourceGroupName,
        String accountName) {
        return new PagedFlux<>(() -> listSqlRoleAssignmentsSinglePageAsync(resourceGroupName, accountName));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignmentsAsync(String resourceGroupName,
        String accountName, Context context) {
        return new PagedFlux<>(() -> listSqlRoleAssignmentsSinglePageAsync(resourceGroupName, accountName, context));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignments(String resourceGroupName,
        String accountName) {
        return new PagedIterable<>(listSqlRoleAssignmentsAsync(resourceGroupName, accountName));
    }

    /**
     * Retrieves the list of all Azure Cosmos DB SQL Role Assignments.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the relevant Role Assignments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SqlRoleAssignmentGetResultsInner> listSqlRoleAssignments(String resourceGroupName,
        String accountName, Context context) {
        return new PagedIterable<>(listSqlRoleAssignmentsAsync(resourceGroupName, accountName, context));
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        ContinuousBackupRestoreLocation location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        } else {
            location.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.retrieveContinuousBackupInformation(this.client.getEndpoint(),
                this.client.getSubscriptionId(), resourceGroupName, accountName, databaseName, containerName,
                this.client.getApiVersion(), location, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String containerName,
        ContinuousBackupRestoreLocation location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        } else {
            location.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.retrieveContinuousBackupInformation(this.client.getEndpoint(), this.client.getSubscriptionId(),
            resourceGroupName, accountName, databaseName, containerName, this.client.getApiVersion(), location, accept,
            context);
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, ContinuousBackupRestoreLocation location) {
        Mono<Response<Flux<ByteBuffer>>> mono = retrieveContinuousBackupInformationWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, location);
        return this.client.<BackupInformationInner, BackupInformationInner>getLroResult(mono,
            this.client.getHttpPipeline(), BackupInformationInner.class, BackupInformationInner.class,
            this.client.getContext());
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(String resourceGroupName, String accountName, String databaseName,
            String containerName, ContinuousBackupRestoreLocation location, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = retrieveContinuousBackupInformationWithResponseAsync(resourceGroupName,
            accountName, databaseName, containerName, location, context);
        return this.client.<BackupInformationInner, BackupInformationInner>getLroResult(mono,
            this.client.getHttpPipeline(), BackupInformationInner.class, BackupInformationInner.class, context);
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformation(String resourceGroupName, String accountName, String databaseName,
            String containerName, ContinuousBackupRestoreLocation location) {
        return this.beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName,
            containerName, location).getSyncPoller();
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformation(String resourceGroupName, String accountName, String databaseName,
            String containerName, ContinuousBackupRestoreLocation location, Context context) {
        return this.beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName,
            containerName, location, context).getSyncPoller();
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, ContinuousBackupRestoreLocation location) {
        return beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName,
            containerName, location).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(String resourceGroupName,
        String accountName, String databaseName, String containerName, ContinuousBackupRestoreLocation location,
        Context context) {
        return beginRetrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName,
            containerName, location, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupInformationInner retrieveContinuousBackupInformation(String resourceGroupName, String accountName,
        String databaseName, String containerName, ContinuousBackupRestoreLocation location) {
        return retrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, containerName,
            location).block();
    }

    /**
     * Retrieves continuous backup information for a container resource.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param containerName Cosmos DB container name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupInformationInner retrieveContinuousBackupInformation(String resourceGroupName, String accountName,
        String databaseName, String containerName, ContinuousBackupRestoreLocation location, Context context) {
        return retrieveContinuousBackupInformationAsync(resourceGroupName, accountName, databaseName, containerName,
            location, context).block();
    }
}
