// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.MongoRoleDefinitionType;
import com.azure.resourcemanager.cosmos.models.Privilege;
import com.azure.resourcemanager.cosmos.models.Role;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Azure Cosmos DB Mongo Role Definition resource object.
 */
@Fluent
public final class MongoRoleDefinitionResource {
    /*
     * A user-friendly name for the Role Definition. Must be unique for the database account.
     */
    @JsonProperty(value = "roleName")
    private String roleName;

    /*
     * Indicates whether the Role Definition was built-in or user created.
     */
    @JsonProperty(value = "type")
    private MongoRoleDefinitionType type;

    /*
     * The database name for which access is being granted for this Role Definition.
     */
    @JsonProperty(value = "databaseName")
    private String databaseName;

    /*
     * A set of privileges contained by the Role Definition. This will allow application of this Role Definition on the
     * entire database account or any underlying Database / Collection. Scopes higher than Database are not enforceable
     * as privilege.
     */
    @JsonProperty(value = "privileges")
    private List<Privilege> privileges;

    /*
     * The set of roles inherited by this Role Definition.
     */
    @JsonProperty(value = "roles")
    private List<Role> roles;

    /**
     * Creates an instance of MongoRoleDefinitionResource class.
     */
    public MongoRoleDefinitionResource() {
    }

    /**
     * Get the roleName property: A user-friendly name for the Role Definition. Must be unique for the database
     * account.
     * 
     * @return the roleName value.
     */
    public String roleName() {
        return this.roleName;
    }

    /**
     * Set the roleName property: A user-friendly name for the Role Definition. Must be unique for the database
     * account.
     * 
     * @param roleName the roleName value to set.
     * @return the MongoRoleDefinitionResource object itself.
     */
    public MongoRoleDefinitionResource withRoleName(String roleName) {
        this.roleName = roleName;
        return this;
    }

    /**
     * Get the type property: Indicates whether the Role Definition was built-in or user created.
     * 
     * @return the type value.
     */
    public MongoRoleDefinitionType type() {
        return this.type;
    }

    /**
     * Set the type property: Indicates whether the Role Definition was built-in or user created.
     * 
     * @param type the type value to set.
     * @return the MongoRoleDefinitionResource object itself.
     */
    public MongoRoleDefinitionResource withType(MongoRoleDefinitionType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the databaseName property: The database name for which access is being granted for this Role Definition.
     * 
     * @return the databaseName value.
     */
    public String databaseName() {
        return this.databaseName;
    }

    /**
     * Set the databaseName property: The database name for which access is being granted for this Role Definition.
     * 
     * @param databaseName the databaseName value to set.
     * @return the MongoRoleDefinitionResource object itself.
     */
    public MongoRoleDefinitionResource withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    /**
     * Get the privileges property: A set of privileges contained by the Role Definition. This will allow application
     * of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher
     * than Database are not enforceable as privilege.
     * 
     * @return the privileges value.
     */
    public List<Privilege> privileges() {
        return this.privileges;
    }

    /**
     * Set the privileges property: A set of privileges contained by the Role Definition. This will allow application
     * of this Role Definition on the entire database account or any underlying Database / Collection. Scopes higher
     * than Database are not enforceable as privilege.
     * 
     * @param privileges the privileges value to set.
     * @return the MongoRoleDefinitionResource object itself.
     */
    public MongoRoleDefinitionResource withPrivileges(List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    /**
     * Get the roles property: The set of roles inherited by this Role Definition.
     * 
     * @return the roles value.
     */
    public List<Role> roles() {
        return this.roles;
    }

    /**
     * Set the roles property: The set of roles inherited by this Role Definition.
     * 
     * @param roles the roles value to set.
     * @return the MongoRoleDefinitionResource object itself.
     */
    public MongoRoleDefinitionResource withRoles(List<Role> roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privileges() != null) {
            privileges().forEach(e -> e.validate());
        }
        if (roles() != null) {
            roles().forEach(e -> e.validate());
        }
    }
}
