// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.GremlinGraphGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.GremlinGraphGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * An Azure Cosmos DB Gremlin graph.
 */
@Fluent
public final class GremlinGraphGetResultsInner extends ArmResourceProperties {
    /*
     * The properties of an Azure Cosmos DB Gremlin graph
     */
    @JsonProperty(value = "properties")
    private GremlinGraphGetProperties innerProperties;

    /**
     * Creates an instance of GremlinGraphGetResultsInner class.
     */
    public GremlinGraphGetResultsInner() {
    }

    /**
     * Get the innerProperties property: The properties of an Azure Cosmos DB Gremlin graph.
     * 
     * @return the innerProperties value.
     */
    private GremlinGraphGetProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GremlinGraphGetResultsInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public GremlinGraphGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the GremlinGraphGetResultsInner object itself.
     */
    public GremlinGraphGetResultsInner withResource(GremlinGraphGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GremlinGraphGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Get the options property: The options property.
     * 
     * @return the options value.
     */
    public GremlinGraphGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    /**
     * Set the options property: The options property.
     * 
     * @param options the options value to set.
     * @return the GremlinGraphGetResultsInner object itself.
     */
    public GremlinGraphGetResultsInner withOptions(GremlinGraphGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GremlinGraphGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
