// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmProxyResource;
import com.azure.resourcemanager.cosmos.models.ClientEncryptionKeyGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Client Encryption Key.
 */
@Fluent
public final class ClientEncryptionKeyGetResultsInner extends ArmProxyResource {
    /*
     * The properties of a ClientEncryptionKey
     */
    @JsonProperty(value = "properties")
    private ClientEncryptionKeyGetProperties innerProperties;

    /**
     * Creates an instance of ClientEncryptionKeyGetResultsInner class.
     */
    public ClientEncryptionKeyGetResultsInner() {
    }

    /**
     * Get the innerProperties property: The properties of a ClientEncryptionKey.
     * 
     * @return the innerProperties value.
     */
    private ClientEncryptionKeyGetProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public ClientEncryptionKeyGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the ClientEncryptionKeyGetResultsInner object itself.
     */
    public ClientEncryptionKeyGetResultsInner withResource(ClientEncryptionKeyGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ClientEncryptionKeyGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
