// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Cosmos DB SQL trigger resource object.
 */
@Fluent
public class SqlTriggerResource {
    /*
     * Name of the Cosmos DB SQL trigger
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * Body of the Trigger
     */
    @JsonProperty(value = "body")
    private String body;

    /*
     * Type of the Trigger
     */
    @JsonProperty(value = "triggerType")
    private TriggerType triggerType;

    /*
     * The operation the trigger is associated with
     */
    @JsonProperty(value = "triggerOperation")
    private TriggerOperation triggerOperation;

    /**
     * Creates an instance of SqlTriggerResource class.
     */
    public SqlTriggerResource() {
    }

    /**
     * Get the id property: Name of the Cosmos DB SQL trigger.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Name of the Cosmos DB SQL trigger.
     * 
     * @param id the id value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the body property: Body of the Trigger.
     * 
     * @return the body value.
     */
    public String body() {
        return this.body;
    }

    /**
     * Set the body property: Body of the Trigger.
     * 
     * @param body the body value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withBody(String body) {
        this.body = body;
        return this;
    }

    /**
     * Get the triggerType property: Type of the Trigger.
     * 
     * @return the triggerType value.
     */
    public TriggerType triggerType() {
        return this.triggerType;
    }

    /**
     * Set the triggerType property: Type of the Trigger.
     * 
     * @param triggerType the triggerType value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withTriggerType(TriggerType triggerType) {
        this.triggerType = triggerType;
        return this;
    }

    /**
     * Get the triggerOperation property: The operation the trigger is associated with.
     * 
     * @return the triggerOperation value.
     */
    public TriggerOperation triggerOperation() {
        return this.triggerOperation;
    }

    /**
     * Set the triggerOperation property: The operation the trigger is associated with.
     * 
     * @param triggerOperation the triggerOperation value to set.
     * @return the SqlTriggerResource object itself.
     */
    public SqlTriggerResource withTriggerOperation(TriggerOperation triggerOperation) {
        this.triggerOperation = triggerOperation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property id in model SqlTriggerResource"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SqlTriggerResource.class);
}
