// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The metadata related to each access key for the given Cosmos DB database account.
 */
@Immutable
public final class DatabaseAccountKeysMetadata {
    /*
     * The metadata related to the Primary Read-Write Key for the given Cosmos DB database account.
     */
    @JsonProperty(value = "primaryMasterKey", access = JsonProperty.Access.WRITE_ONLY)
    private AccountKeyMetadata primaryMasterKey;

    /*
     * The metadata related to the Secondary Read-Write Key for the given Cosmos DB database account.
     */
    @JsonProperty(value = "secondaryMasterKey", access = JsonProperty.Access.WRITE_ONLY)
    private AccountKeyMetadata secondaryMasterKey;

    /*
     * The metadata related to the Primary Read-Only Key for the given Cosmos DB database account.
     */
    @JsonProperty(value = "primaryReadonlyMasterKey", access = JsonProperty.Access.WRITE_ONLY)
    private AccountKeyMetadata primaryReadonlyMasterKey;

    /*
     * The metadata related to the Secondary Read-Only Key for the given Cosmos DB database account.
     */
    @JsonProperty(value = "secondaryReadonlyMasterKey", access = JsonProperty.Access.WRITE_ONLY)
    private AccountKeyMetadata secondaryReadonlyMasterKey;

    /**
     * Creates an instance of DatabaseAccountKeysMetadata class.
     */
    public DatabaseAccountKeysMetadata() {
    }

    /**
     * Get the primaryMasterKey property: The metadata related to the Primary Read-Write Key for the given Cosmos DB
     * database account.
     * 
     * @return the primaryMasterKey value.
     */
    public AccountKeyMetadata primaryMasterKey() {
        return this.primaryMasterKey;
    }

    /**
     * Get the secondaryMasterKey property: The metadata related to the Secondary Read-Write Key for the given Cosmos
     * DB database account.
     * 
     * @return the secondaryMasterKey value.
     */
    public AccountKeyMetadata secondaryMasterKey() {
        return this.secondaryMasterKey;
    }

    /**
     * Get the primaryReadonlyMasterKey property: The metadata related to the Primary Read-Only Key for the given
     * Cosmos DB database account.
     * 
     * @return the primaryReadonlyMasterKey value.
     */
    public AccountKeyMetadata primaryReadonlyMasterKey() {
        return this.primaryReadonlyMasterKey;
    }

    /**
     * Get the secondaryReadonlyMasterKey property: The metadata related to the Secondary Read-Only Key for the given
     * Cosmos DB database account.
     * 
     * @return the secondaryReadonlyMasterKey value.
     */
    public AccountKeyMetadata secondaryReadonlyMasterKey() {
        return this.secondaryReadonlyMasterKey;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (primaryMasterKey() != null) {
            primaryMasterKey().validate();
        }
        if (secondaryMasterKey() != null) {
            secondaryMasterKey().validate();
        }
        if (primaryReadonlyMasterKey() != null) {
            primaryReadonlyMasterKey().validate();
        }
        if (secondaryReadonlyMasterKey() != null) {
            secondaryReadonlyMasterKey().validate();
        }
    }
}
