// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.CassandraDataCentersClient;
import com.azure.resourcemanager.cosmos.fluent.models.DataCenterResourceInner;
import com.azure.resourcemanager.cosmos.models.ListDataCenters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in CassandraDataCentersClient.
 */
public final class CassandraDataCentersClientImpl implements CassandraDataCentersClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final CassandraDataCentersService service;

    /**
     * The service client containing this operation class.
     */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of CassandraDataCentersClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    CassandraDataCentersClientImpl(CosmosDBManagementClientImpl client) {
        this.service = RestProxy.create(CassandraDataCentersService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientCassandraDataCenters to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementCl")
    public interface CassandraDataCentersService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ListDataCenters>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("clusterName") String clusterName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters/{dataCenterName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<DataCenterResourceInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("clusterName") String clusterName,
            @PathParam("dataCenterName") String dataCenterName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters/{dataCenterName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("clusterName") String clusterName,
            @PathParam("dataCenterName") String dataCenterName, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters/{dataCenterName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("clusterName") String clusterName,
            @PathParam("dataCenterName") String dataCenterName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DataCenterResourceInner body, @HeaderParam("Accept") String accept,
            Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/cassandraClusters/{clusterName}/dataCenters/{dataCenterName}")
        @ExpectedResponses({ 200, 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("clusterName") String clusterName,
            @PathParam("dataCenterName") String dataCenterName, @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") DataCenterResourceInner body, @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * List all data centers in a particular managed Cassandra cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of managed Cassandra data centers and their properties along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCenterResourceInner>> listSinglePageAsync(String resourceGroupName,
        String clusterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, clusterName, this.client.getApiVersion(), accept, context))
            .<PagedResponse<DataCenterResourceInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List all data centers in a particular managed Cassandra cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of managed Cassandra data centers and their properties along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<DataCenterResourceInner>> listSinglePageAsync(String resourceGroupName,
        String clusterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName,
                this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), null, null));
    }

    /**
     * List all data centers in a particular managed Cassandra cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of managed Cassandra data centers and their properties as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataCenterResourceInner> listAsync(String resourceGroupName, String clusterName) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, clusterName));
    }

    /**
     * List all data centers in a particular managed Cassandra cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of managed Cassandra data centers and their properties as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<DataCenterResourceInner> listAsync(String resourceGroupName, String clusterName,
        Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(resourceGroupName, clusterName, context));
    }

    /**
     * List all data centers in a particular managed Cassandra cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of managed Cassandra data centers and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataCenterResourceInner> list(String resourceGroupName, String clusterName) {
        return new PagedIterable<>(listAsync(resourceGroupName, clusterName));
    }

    /**
     * List all data centers in a particular managed Cassandra cluster.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of managed Cassandra data centers and their properties as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataCenterResourceInner> list(String resourceGroupName, String clusterName, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, clusterName, context));
    }

    /**
     * Get the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a managed Cassandra data center along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataCenterResourceInner>> getWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, clusterName, dataCenterName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a managed Cassandra data center along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<DataCenterResourceInner>> getWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, clusterName,
            dataCenterName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Get the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a managed Cassandra data center on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCenterResourceInner> getAsync(String resourceGroupName, String clusterName, String dataCenterName) {
        return getWithResponseAsync(resourceGroupName, clusterName, dataCenterName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Get the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a managed Cassandra data center along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataCenterResourceInner> getWithResponse(String resourceGroupName, String clusterName,
        String dataCenterName, Context context) {
        return getWithResponseAsync(resourceGroupName, clusterName, dataCenterName, context).block();
    }

    /**
     * Get the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the properties of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCenterResourceInner get(String resourceGroupName, String clusterName, String dataCenterName) {
        return getWithResponse(resourceGroupName, clusterName, dataCenterName, Context.NONE).getValue();
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, clusterName, dataCenterName, this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            clusterName, dataCenterName, this.client.getApiVersion(), accept, context);
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String clusterName,
        String dataCenterName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, clusterName, dataCenterName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String clusterName,
        String dataCenterName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, clusterName, dataCenterName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String clusterName,
        String dataCenterName) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, dataCenterName).getSyncPoller();
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String clusterName,
        String dataCenterName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, clusterName, dataCenterName, context).getSyncPoller();
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String dataCenterName) {
        return beginDeleteAsync(resourceGroupName, clusterName, dataCenterName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String clusterName, String dataCenterName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, clusterName, dataCenterName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String clusterName, String dataCenterName) {
        deleteAsync(resourceGroupName, clusterName, dataCenterName).block();
    }

    /**
     * Delete a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String clusterName, String dataCenterName, Context context) {
        deleteAsync(resourceGroupName, clusterName, dataCenterName, context).block();
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, clusterName, dataCenterName, this.client.getApiVersion(), body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            clusterName, dataCenterName, this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginCreateUpdateAsync(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = createUpdateWithResponseAsync(resourceGroupName, clusterName, dataCenterName, body);
        return this.client.<DataCenterResourceInner, DataCenterResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), DataCenterResourceInner.class, DataCenterResourceInner.class,
            this.client.getContext());
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginCreateUpdateAsync(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = createUpdateWithResponseAsync(resourceGroupName, clusterName, dataCenterName, body, context);
        return this.client.<DataCenterResourceInner, DataCenterResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), DataCenterResourceInner.class, DataCenterResourceInner.class, context);
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginCreateUpdate(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body) {
        return this.beginCreateUpdateAsync(resourceGroupName, clusterName, dataCenterName, body).getSyncPoller();
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginCreateUpdate(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body,
        Context context) {
        return this.beginCreateUpdateAsync(resourceGroupName, clusterName, dataCenterName, body, context)
            .getSyncPoller();
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCenterResourceInner> createUpdateAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body) {
        return beginCreateUpdateAsync(resourceGroupName, clusterName, dataCenterName, body).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DataCenterResourceInner> createUpdateAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body, Context context) {
        return beginCreateUpdateAsync(resourceGroupName, clusterName, dataCenterName, body, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCenterResourceInner createUpdate(String resourceGroupName, String clusterName, String dataCenterName,
        DataCenterResourceInner body) {
        return createUpdateAsync(resourceGroupName, clusterName, dataCenterName, body).block();
    }

    /**
     * Create or update a managed Cassandra data center. When updating, overwrite all properties. To update only some
     * properties, use PATCH.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCenterResourceInner createUpdate(String resourceGroupName, String clusterName, String dataCenterName,
        DataCenterResourceInner body, Context context) {
        return createUpdateAsync(resourceGroupName, clusterName, dataCenterName, body, context).block();
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, clusterName, dataCenterName, this.client.getApiVersion(), body, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (clusterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter clusterName is required and cannot be null."));
        }
        if (dataCenterName == null) {
            return Mono.error(new IllegalArgumentException("Parameter dataCenterName is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error(new IllegalArgumentException("Parameter body is required and cannot be null."));
        } else {
            body.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            clusterName, dataCenterName, this.client.getApiVersion(), body, accept, context);
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginUpdateAsync(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, clusterName, dataCenterName, body);
        return this.client.<DataCenterResourceInner, DataCenterResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), DataCenterResourceInner.class, DataCenterResourceInner.class,
            this.client.getContext());
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginUpdateAsync(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = updateWithResponseAsync(resourceGroupName, clusterName, dataCenterName, body, context);
        return this.client.<DataCenterResourceInner, DataCenterResourceInner>getLroResult(mono,
            this.client.getHttpPipeline(), DataCenterResourceInner.class, DataCenterResourceInner.class, context);
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataCenterResourceInner>, DataCenterResourceInner>
        beginUpdate(String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, dataCenterName, body).getSyncPoller();
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DataCenterResourceInner>, DataCenterResourceInner> beginUpdate(
        String resourceGroupName, String clusterName, String dataCenterName, DataCenterResourceInner body,
        Context context) {
        return this.beginUpdateAsync(resourceGroupName, clusterName, dataCenterName, body, context).getSyncPoller();
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataCenterResourceInner> updateAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body) {
        return beginUpdateAsync(resourceGroupName, clusterName, dataCenterName, body).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<DataCenterResourceInner> updateAsync(String resourceGroupName, String clusterName,
        String dataCenterName, DataCenterResourceInner body, Context context) {
        return beginUpdateAsync(resourceGroupName, clusterName, dataCenterName, body, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCenterResourceInner update(String resourceGroupName, String clusterName, String dataCenterName,
        DataCenterResourceInner body) {
        return updateAsync(resourceGroupName, clusterName, dataCenterName, body).block();
    }

    /**
     * Update some of the properties of a managed Cassandra data center.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param clusterName Managed Cassandra cluster name.
     * @param dataCenterName Data center name in a managed Cassandra cluster.
     * @param body Parameters to provide for specifying the managed Cassandra data center.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a managed Cassandra data center.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataCenterResourceInner update(String resourceGroupName, String clusterName, String dataCenterName,
        DataCenterResourceInner body, Context context) {
        return updateAsync(resourceGroupName, clusterName, dataCenterName, body, context).block();
    }
}
