// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.RestorableTablePropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties of an Azure Cosmos DB Table event.
 */
@Fluent
public final class RestorableTableProperties {
    /*
     * The resource of an Azure Cosmos DB Table event
     */
    @JsonProperty(value = "resource")
    private RestorableTablePropertiesResource resource;

    /**
     * Creates an instance of RestorableTableProperties class.
     */
    public RestorableTableProperties() {
    }

    /**
     * Get the resource property: The resource of an Azure Cosmos DB Table event.
     * 
     * @return the resource value.
     */
    public RestorableTablePropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource of an Azure Cosmos DB Table event.
     * 
     * @param resource the resource value to set.
     * @return the RestorableTableProperties object itself.
     */
    public RestorableTableProperties withResource(RestorableTablePropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }
}
