// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.SqlDatabaseGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The properties of an Azure Cosmos DB SQL database.
 */
@Fluent
public final class SqlDatabaseGetProperties {
    /*
     * The resource property.
     */
    @JsonProperty(value = "resource")
    private SqlDatabaseGetPropertiesResource resource;

    /*
     * The options property.
     */
    @JsonProperty(value = "options")
    private SqlDatabaseGetPropertiesOptions options;

    /**
     * Creates an instance of SqlDatabaseGetProperties class.
     */
    public SqlDatabaseGetProperties() {
    }

    /**
     * Get the resource property: The resource property.
     * 
     * @return the resource value.
     */
    public SqlDatabaseGetPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     * 
     * @param resource the resource value to set.
     * @return the SqlDatabaseGetProperties object itself.
     */
    public SqlDatabaseGetProperties withResource(SqlDatabaseGetPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the options property: The options property.
     * 
     * @return the options value.
     */
    public SqlDatabaseGetPropertiesOptions options() {
        return this.options;
    }

    /**
     * Set the options property: The options property.
     * 
     * @param options the options value to set.
     * @return the SqlDatabaseGetProperties object itself.
     */
    public SqlDatabaseGetProperties withOptions(SqlDatabaseGetPropertiesOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
        if (options() != null) {
            options().validate();
        }
    }
}
