/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.models.CassandraClusterPublicStatusInner;
import com.azure.resourcemanager.cosmos.fluent.models.ClusterResourceInner;
import com.azure.resourcemanager.cosmos.fluent.models.CommandOutputInner;
import com.azure.resourcemanager.cosmos.models.CommandPostBody;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface CassandraClustersClient
extends InnerSupportsGet<ClusterResourceInner>,
InnerSupportsListing<ClusterResourceInner>,
InnerSupportsDelete<Void> {
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ClusterResourceInner> listAsync();

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterResourceInner> list();

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterResourceInner> list(Context var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ClusterResourceInner> listByResourceGroupAsync(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterResourceInner> listByResourceGroup(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ClusterResourceInner> listByResourceGroup(String var1, Context var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ClusterResourceInner>> getByResourceGroupWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ClusterResourceInner> getByResourceGroupAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterResourceInner getByResourceGroup(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ClusterResourceInner> getByResourceGroupWithResponse(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateWithResponseAsync(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ClusterResourceInner>, ClusterResourceInner> beginCreateUpdateAsync(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterResourceInner>, ClusterResourceInner> beginCreateUpdate(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterResourceInner>, ClusterResourceInner> beginCreateUpdate(String var1, String var2, ClusterResourceInner var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ClusterResourceInner> createUpdateAsync(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterResourceInner createUpdate(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterResourceInner createUpdate(String var1, String var2, ClusterResourceInner var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ClusterResourceInner>, ClusterResourceInner> beginUpdateAsync(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterResourceInner>, ClusterResourceInner> beginUpdate(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ClusterResourceInner>, ClusterResourceInner> beginUpdate(String var1, String var2, ClusterResourceInner var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ClusterResourceInner> updateAsync(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterResourceInner update(String var1, String var2, ClusterResourceInner var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ClusterResourceInner update(String var1, String var2, ClusterResourceInner var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> invokeCommandWithResponseAsync(String var1, String var2, CommandPostBody var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<CommandOutputInner>, CommandOutputInner> beginInvokeCommandAsync(String var1, String var2, CommandPostBody var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CommandOutputInner>, CommandOutputInner> beginInvokeCommand(String var1, String var2, CommandPostBody var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CommandOutputInner>, CommandOutputInner> beginInvokeCommand(String var1, String var2, CommandPostBody var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommandOutputInner> invokeCommandAsync(String var1, String var2, CommandPostBody var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommandOutputInner invokeCommand(String var1, String var2, CommandPostBody var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommandOutputInner invokeCommand(String var1, String var2, CommandPostBody var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deallocateWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeallocateAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeallocate(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deallocateAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocate(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deallocate(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginStartAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginStart(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CassandraClusterPublicStatusInner>> statusWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CassandraClusterPublicStatusInner> statusAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CassandraClusterPublicStatusInner status(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CassandraClusterPublicStatusInner> statusWithResponse(String var1, String var2, Context var3);
}

