// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleDefinitionGetResultsInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The relevant Role Definitions. */
@Immutable
public final class SqlRoleDefinitionListResult {
    /*
     * List of Role Definitions and their properties.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<SqlRoleDefinitionGetResultsInner> value;

    /**
     * Get the value property: List of Role Definitions and their properties.
     *
     * @return the value value.
     */
    public List<SqlRoleDefinitionGetResultsInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
