// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Parameters to indicate the information about the restore. */
@Fluent
public final class RestoreParameters {
    /*
     * Describes the mode of the restore.
     */
    @JsonProperty(value = "restoreMode")
    private RestoreMode restoreMode;

    /*
     * The id of the restorable database account from which the restore has to be initiated. For example:
     * /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
     */
    @JsonProperty(value = "restoreSource")
    private String restoreSource;

    /*
     * Time to which the account has to be restored (ISO-8601 format).
     */
    @JsonProperty(value = "restoreTimestampInUtc")
    private OffsetDateTime restoreTimestampInUtc;

    /*
     * List of specific databases available for restore.
     */
    @JsonProperty(value = "databasesToRestore")
    private List<DatabaseRestoreResource> databasesToRestore;

    /**
     * Get the restoreMode property: Describes the mode of the restore.
     *
     * @return the restoreMode value.
     */
    public RestoreMode restoreMode() {
        return this.restoreMode;
    }

    /**
     * Set the restoreMode property: Describes the mode of the restore.
     *
     * @param restoreMode the restoreMode value to set.
     * @return the RestoreParameters object itself.
     */
    public RestoreParameters withRestoreMode(RestoreMode restoreMode) {
        this.restoreMode = restoreMode;
        return this;
    }

    /**
     * Get the restoreSource property: The id of the restorable database account from which the restore has to be
     * initiated. For example:
     * /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.
     *
     * @return the restoreSource value.
     */
    public String restoreSource() {
        return this.restoreSource;
    }

    /**
     * Set the restoreSource property: The id of the restorable database account from which the restore has to be
     * initiated. For example:
     * /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}.
     *
     * @param restoreSource the restoreSource value to set.
     * @return the RestoreParameters object itself.
     */
    public RestoreParameters withRestoreSource(String restoreSource) {
        this.restoreSource = restoreSource;
        return this;
    }

    /**
     * Get the restoreTimestampInUtc property: Time to which the account has to be restored (ISO-8601 format).
     *
     * @return the restoreTimestampInUtc value.
     */
    public OffsetDateTime restoreTimestampInUtc() {
        return this.restoreTimestampInUtc;
    }

    /**
     * Set the restoreTimestampInUtc property: Time to which the account has to be restored (ISO-8601 format).
     *
     * @param restoreTimestampInUtc the restoreTimestampInUtc value to set.
     * @return the RestoreParameters object itself.
     */
    public RestoreParameters withRestoreTimestampInUtc(OffsetDateTime restoreTimestampInUtc) {
        this.restoreTimestampInUtc = restoreTimestampInUtc;
        return this;
    }

    /**
     * Get the databasesToRestore property: List of specific databases available for restore.
     *
     * @return the databasesToRestore value.
     */
    public List<DatabaseRestoreResource> databasesToRestore() {
        return this.databasesToRestore;
    }

    /**
     * Set the databasesToRestore property: List of specific databases available for restore.
     *
     * @param databasesToRestore the databasesToRestore value to set.
     * @return the RestoreParameters object itself.
     */
    public RestoreParameters withDatabasesToRestore(List<DatabaseRestoreResource> databasesToRestore) {
        this.databasesToRestore = databasesToRestore;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (databasesToRestore() != null) {
            databasesToRestore().forEach(e -> e.validate());
        }
    }
}
