// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** An Azure Cosmos DB Mongo DB Resource. */
@Fluent
public final class PrivilegeResource {
    /*
     * The database name the role is applied.
     */
    @JsonProperty(value = "db")
    private String db;

    /*
     * The collection name the role is applied.
     */
    @JsonProperty(value = "collection")
    private String collection;

    /**
     * Get the db property: The database name the role is applied.
     *
     * @return the db value.
     */
    public String db() {
        return this.db;
    }

    /**
     * Set the db property: The database name the role is applied.
     *
     * @param db the db value to set.
     * @return the PrivilegeResource object itself.
     */
    public PrivilegeResource withDb(String db) {
        this.db = db;
        return this;
    }

    /**
     * Get the collection property: The collection name the role is applied.
     *
     * @return the collection value.
     */
    public String collection() {
        return this.collection;
    }

    /**
     * Set the collection property: The collection name the role is applied.
     *
     * @param collection the collection value to set.
     * @return the PrivilegeResource object itself.
     */
    public PrivilegeResource withCollection(String collection) {
        this.collection = collection;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
