// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Identity for the resource. */
@Fluent
public class ManagedCassandraManagedServiceIdentity {
    /*
     * The object id of the identity resource.
     */
    @JsonProperty(value = "principalId", access = JsonProperty.Access.WRITE_ONLY)
    private String principalId;

    /*
     * The tenant id of the resource.
     */
    @JsonProperty(value = "tenantId", access = JsonProperty.Access.WRITE_ONLY)
    private String tenantId;

    /*
     * The type of the resource.
     */
    @JsonProperty(value = "type")
    private ManagedCassandraResourceIdentityType type;

    /**
     * Get the principalId property: The object id of the identity resource.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The tenant id of the resource.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: The type of the resource.
     *
     * @return the type value.
     */
    public ManagedCassandraResourceIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource.
     *
     * @param type the type value to set.
     * @return the ManagedCassandraManagedServiceIdentity object itself.
     */
    public ManagedCassandraManagedServiceIdentity withType(ManagedCassandraResourceIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
