// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * CreateUpdateOptions are a list of key-value pairs that describe the resource. Supported keys are "If-Match",
 * "If-None-Match", "Session-Token" and "Throughput".
 */
@Fluent
public final class CreateUpdateOptions {
    /*
     * Request Units per second. For example, "throughput": 10000.
     */
    @JsonProperty(value = "throughput")
    private Integer throughput;

    /*
     * Specifies the Autoscale settings.
     */
    @JsonProperty(value = "autoscaleSettings")
    private AutoscaleSettings autoscaleSettings;

    /**
     * Get the throughput property: Request Units per second. For example, "throughput": 10000.
     *
     * @return the throughput value.
     */
    public Integer throughput() {
        return this.throughput;
    }

    /**
     * Set the throughput property: Request Units per second. For example, "throughput": 10000.
     *
     * @param throughput the throughput value to set.
     * @return the CreateUpdateOptions object itself.
     */
    public CreateUpdateOptions withThroughput(Integer throughput) {
        this.throughput = throughput;
        return this;
    }

    /**
     * Get the autoscaleSettings property: Specifies the Autoscale settings.
     *
     * @return the autoscaleSettings value.
     */
    public AutoscaleSettings autoscaleSettings() {
        return this.autoscaleSettings;
    }

    /**
     * Set the autoscaleSettings property: Specifies the Autoscale settings.
     *
     * @param autoscaleSettings the autoscaleSettings value to set.
     * @return the CreateUpdateOptions object itself.
     */
    public CreateUpdateOptions withAutoscaleSettings(AutoscaleSettings autoscaleSettings) {
        this.autoscaleSettings = autoscaleSettings;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (autoscaleSettings() != null) {
            autoscaleSettings().validate();
        }
    }
}
