// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ApiType;
import com.azure.resourcemanager.cosmos.models.RestorableLocationResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** A Azure Cosmos DB restorable database account. */
@Fluent
public final class RestorableDatabaseAccountGetResultInner {
    /*
     * The properties of a restorable database account.
     */
    @JsonProperty(value = "properties")
    private RestorableDatabaseAccountProperties innerProperties;

    /*
     * The unique resource identifier of the ARM resource.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The name of the ARM resource.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The type of Azure resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The location of the resource group to which the resource belongs.
     */
    @JsonProperty(value = "location")
    private String location;

    /**
     * Get the innerProperties property: The properties of a restorable database account.
     *
     * @return the innerProperties value.
     */
    private RestorableDatabaseAccountProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: The unique resource identifier of the ARM resource.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the ARM resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of Azure resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the location property: The location of the resource group to which the resource belongs.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the resource group to which the resource belongs.
     *
     * @param location the location value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the accountName property: The name of the global database account.
     *
     * @return the accountName value.
     */
    public String accountName() {
        return this.innerProperties() == null ? null : this.innerProperties().accountName();
    }

    /**
     * Set the accountName property: The name of the global database account.
     *
     * @param accountName the accountName value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withAccountName(String accountName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withAccountName(accountName);
        return this;
    }

    /**
     * Get the creationTime property: The creation time of the restorable database account (ISO-8601 format).
     *
     * @return the creationTime value.
     */
    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    /**
     * Set the creationTime property: The creation time of the restorable database account (ISO-8601 format).
     *
     * @param creationTime the creationTime value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    /**
     * Get the deletionTime property: The time at which the restorable database account has been deleted (ISO-8601
     * format).
     *
     * @return the deletionTime value.
     */
    public OffsetDateTime deletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionTime();
    }

    /**
     * Set the deletionTime property: The time at which the restorable database account has been deleted (ISO-8601
     * format).
     *
     * @param deletionTime the deletionTime value to set.
     * @return the RestorableDatabaseAccountGetResultInner object itself.
     */
    public RestorableDatabaseAccountGetResultInner withDeletionTime(OffsetDateTime deletionTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withDeletionTime(deletionTime);
        return this;
    }

    /**
     * Get the apiType property: The API type of the restorable database account.
     *
     * @return the apiType value.
     */
    public ApiType apiType() {
        return this.innerProperties() == null ? null : this.innerProperties().apiType();
    }

    /**
     * Get the restorableLocations property: List of regions where the of the database account can be restored from.
     *
     * @return the restorableLocations value.
     */
    public List<RestorableLocationResource> restorableLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableLocations();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
