// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of an Azure Cosmos DB MongoDB database. */
@Fluent
public final class MongoDBDatabaseGetProperties {
    /*
     * The resource property.
     */
    @JsonProperty(value = "resource")
    private MongoDBDatabaseGetPropertiesResource resource;

    /*
     * The options property.
     */
    @JsonProperty(value = "options")
    private MongoDBDatabaseGetPropertiesOptions options;

    /**
     * Get the resource property: The resource property.
     *
     * @return the resource value.
     */
    public MongoDBDatabaseGetPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource property.
     *
     * @param resource the resource value to set.
     * @return the MongoDBDatabaseGetProperties object itself.
     */
    public MongoDBDatabaseGetProperties withResource(MongoDBDatabaseGetPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the options property: The options property.
     *
     * @return the options value.
     */
    public MongoDBDatabaseGetPropertiesOptions options() {
        return this.options;
    }

    /**
     * Set the options property: The options property.
     *
     * @param options the options value to set.
     * @return the MongoDBDatabaseGetProperties object itself.
     */
    public MongoDBDatabaseGetProperties withOptions(MongoDBDatabaseGetPropertiesOptions options) {
        this.options = options;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
        if (options() != null) {
            options().validate();
        }
    }
}
