// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The type of the resource. */
public final class ManagedCassandraResourceIdentityType
    extends ExpandableStringEnum<ManagedCassandraResourceIdentityType> {
    /** Static value SystemAssigned for ManagedCassandraResourceIdentityType. */
    public static final ManagedCassandraResourceIdentityType SYSTEM_ASSIGNED = fromString("SystemAssigned");

    /** Static value None for ManagedCassandraResourceIdentityType. */
    public static final ManagedCassandraResourceIdentityType NONE = fromString("None");

    /**
     * Creates or finds a ManagedCassandraResourceIdentityType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ManagedCassandraResourceIdentityType.
     */
    @JsonCreator
    public static ManagedCassandraResourceIdentityType fromString(String name) {
        return fromString(name, ManagedCassandraResourceIdentityType.class);
    }

    /**
     * Gets known ManagedCassandraResourceIdentityType values.
     *
     * @return known ManagedCassandraResourceIdentityType values.
     */
    public static Collection<ManagedCassandraResourceIdentityType> values() {
        return values(ManagedCassandraResourceIdentityType.class);
    }
}
