// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The indexes for the path. */
@Fluent
public final class Indexes {
    /*
     * The datatype for which the indexing behavior is applied to.
     */
    @JsonProperty(value = "dataType")
    private DataType dataType;

    /*
     * The precision of the index. -1 is maximum precision.
     */
    @JsonProperty(value = "precision")
    private Integer precision;

    /*
     * Indicates the type of index.
     */
    @JsonProperty(value = "kind")
    private IndexKind kind;

    /**
     * Get the dataType property: The datatype for which the indexing behavior is applied to.
     *
     * @return the dataType value.
     */
    public DataType dataType() {
        return this.dataType;
    }

    /**
     * Set the dataType property: The datatype for which the indexing behavior is applied to.
     *
     * @param dataType the dataType value to set.
     * @return the Indexes object itself.
     */
    public Indexes withDataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    /**
     * Get the precision property: The precision of the index. -1 is maximum precision.
     *
     * @return the precision value.
     */
    public Integer precision() {
        return this.precision;
    }

    /**
     * Set the precision property: The precision of the index. -1 is maximum precision.
     *
     * @param precision the precision value to set.
     * @return the Indexes object itself.
     */
    public Indexes withPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    /**
     * Get the kind property: Indicates the type of index.
     *
     * @return the kind value.
     */
    public IndexKind kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Indicates the type of index.
     *
     * @param kind the kind value to set.
     * @return the Indexes object itself.
     */
    public Indexes withKind(IndexKind kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
