// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** The kind of connection error that occurred. */
public final class ConnectionState extends ExpandableStringEnum<ConnectionState> {
    /** Static value Unknown for ConnectionState. */
    public static final ConnectionState UNKNOWN = fromString("Unknown");

    /** Static value OK for ConnectionState. */
    public static final ConnectionState OK = fromString("OK");

    /** Static value OperatorToDataCenterNetworkError for ConnectionState. */
    public static final ConnectionState OPERATOR_TO_DATA_CENTER_NETWORK_ERROR =
        fromString("OperatorToDataCenterNetworkError");

    /** Static value DatacenterToDatacenterNetworkError for ConnectionState. */
    public static final ConnectionState DATACENTER_TO_DATACENTER_NETWORK_ERROR =
        fromString("DatacenterToDatacenterNetworkError");

    /** Static value InternalOperatorToDataCenterCertificateError for ConnectionState. */
    public static final ConnectionState INTERNAL_OPERATOR_TO_DATA_CENTER_CERTIFICATE_ERROR =
        fromString("InternalOperatorToDataCenterCertificateError");

    /** Static value InternalError for ConnectionState. */
    public static final ConnectionState INTERNAL_ERROR = fromString("InternalError");

    /**
     * Creates or finds a ConnectionState from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ConnectionState.
     */
    @JsonCreator
    public static ConnectionState fromString(String name) {
        return fromString(name, ConnectionState.class);
    }

    /**
     * Gets known ConnectionState values.
     *
     * @return known ConnectionState values.
     */
    public static Collection<ConnectionState> values() {
        return values(ConnectionState.class);
    }
}
