// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Analytical storage specific properties. */
@Fluent
public final class AnalyticalStorageConfiguration {
    /*
     * Describes the types of schema for analytical storage.
     */
    @JsonProperty(value = "schemaType")
    private AnalyticalStorageSchemaType schemaType;

    /**
     * Get the schemaType property: Describes the types of schema for analytical storage.
     *
     * @return the schemaType value.
     */
    public AnalyticalStorageSchemaType schemaType() {
        return this.schemaType;
    }

    /**
     * Set the schemaType property: Describes the types of schema for analytical storage.
     *
     * @param schemaType the schemaType value to set.
     * @return the AnalyticalStorageConfiguration object itself.
     */
    public AnalyticalStorageConfiguration withSchemaType(AnalyticalStorageSchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
