// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.SqlContainerGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.SqlContainerGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** An Azure Cosmos DB container. */
@Fluent
public final class SqlContainerGetResultsInner extends ArmResourceProperties {
    /*
     * The properties of an Azure Cosmos DB container
     */
    @JsonProperty(value = "properties")
    private SqlContainerGetProperties innerProperties;

    /**
     * Get the innerProperties property: The properties of an Azure Cosmos DB container.
     *
     * @return the innerProperties value.
     */
    private SqlContainerGetProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public SqlContainerGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SqlContainerGetResultsInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resource property: The resource property.
     *
     * @return the resource value.
     */
    public SqlContainerGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     *
     * @param resource the resource value to set.
     * @return the SqlContainerGetResultsInner object itself.
     */
    public SqlContainerGetResultsInner withResource(SqlContainerGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlContainerGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Get the options property: The options property.
     *
     * @return the options value.
     */
    public SqlContainerGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    /**
     * Set the options property: The options property.
     *
     * @param options the options value to set.
     * @return the SqlContainerGetResultsInner object itself.
     */
    public SqlContainerGetResultsInner withOptions(SqlContainerGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlContainerGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
