// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.cosmos.models.RestorableMongodbCollectionPropertiesResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties of an Azure Cosmos DB MongoDB collection event. */
@Fluent
public final class RestorableMongodbCollectionProperties {
    /*
     * The resource of an Azure Cosmos DB MongoDB collection event
     */
    @JsonProperty(value = "resource")
    private RestorableMongodbCollectionPropertiesResource resource;

    /**
     * Get the resource property: The resource of an Azure Cosmos DB MongoDB collection event.
     *
     * @return the resource value.
     */
    public RestorableMongodbCollectionPropertiesResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The resource of an Azure Cosmos DB MongoDB collection event.
     *
     * @param resource the resource value to set.
     * @return the RestorableMongodbCollectionProperties object itself.
     */
    public RestorableMongodbCollectionProperties withResource(RestorableMongodbCollectionPropertiesResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() != null) {
            resource().validate();
        }
    }
}
