/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.TableCreateUpdateProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.CreateUpdateOptions;
import com.azure.resourcemanager.cosmos.models.TableResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class TableCreateUpdateParameters
extends ArmResourceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(TableCreateUpdateParameters.class);
    @JsonProperty(value="properties", required=true)
    private TableCreateUpdateProperties innerProperties = new TableCreateUpdateProperties();

    private TableCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public TableCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public TableCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public TableResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public TableCreateUpdateParameters withResource(TableResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public TableCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new TableCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model TableCreateUpdateParameters"));
        }
        this.innerProperties().validate();
    }
}

