/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.DatabaseRestoreResourceInner;
import com.azure.resourcemanager.cosmos.models.RestoreMode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RestoreParameters {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RestoreParameters.class);
    @JsonProperty(value="restoreMode")
    private RestoreMode restoreMode;
    @JsonProperty(value="restoreSource")
    private String restoreSource;
    @JsonProperty(value="restoreTimestampInUtc")
    private OffsetDateTime restoreTimestampInUtc;
    @JsonProperty(value="databasesToRestore")
    private List<DatabaseRestoreResourceInner> databasesToRestore;

    public RestoreMode restoreMode() {
        return this.restoreMode;
    }

    public RestoreParameters withRestoreMode(RestoreMode restoreMode) {
        this.restoreMode = restoreMode;
        return this;
    }

    public String restoreSource() {
        return this.restoreSource;
    }

    public RestoreParameters withRestoreSource(String restoreSource) {
        this.restoreSource = restoreSource;
        return this;
    }

    public OffsetDateTime restoreTimestampInUtc() {
        return this.restoreTimestampInUtc;
    }

    public RestoreParameters withRestoreTimestampInUtc(OffsetDateTime restoreTimestampInUtc) {
        this.restoreTimestampInUtc = restoreTimestampInUtc;
        return this;
    }

    public List<DatabaseRestoreResourceInner> databasesToRestore() {
        return this.databasesToRestore;
    }

    public RestoreParameters withDatabasesToRestore(List<DatabaseRestoreResourceInner> databasesToRestore) {
        this.databasesToRestore = databasesToRestore;
        return this;
    }

    public void validate() {
        if (this.databasesToRestore() != null) {
            this.databasesToRestore().forEach(e -> e.validate());
        }
    }
}

