/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableDatabaseAccountProperties;
import com.azure.resourcemanager.cosmos.models.ApiType;
import com.azure.resourcemanager.cosmos.models.RestorableLocationResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RestorableDatabaseAccountGetResultInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RestorableDatabaseAccountGetResultInner.class);
    @JsonProperty(value="properties")
    private RestorableDatabaseAccountProperties innerProperties;
    @JsonProperty(value="id", access=JsonProperty.Access.WRITE_ONLY)
    private String id;
    @JsonProperty(value="name", access=JsonProperty.Access.WRITE_ONLY)
    private String name;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;
    @JsonProperty(value="location")
    private String location;

    private RestorableDatabaseAccountProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public RestorableDatabaseAccountGetResultInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public String accountName() {
        return this.innerProperties() == null ? null : this.innerProperties().accountName();
    }

    public RestorableDatabaseAccountGetResultInner withAccountName(String accountName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withAccountName(accountName);
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public RestorableDatabaseAccountGetResultInner withCreationTime(OffsetDateTime creationTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withCreationTime(creationTime);
        return this;
    }

    public OffsetDateTime deletionTime() {
        return this.innerProperties() == null ? null : this.innerProperties().deletionTime();
    }

    public RestorableDatabaseAccountGetResultInner withDeletionTime(OffsetDateTime deletionTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorableDatabaseAccountProperties();
        }
        this.innerProperties().withDeletionTime(deletionTime);
        return this;
    }

    public ApiType apiType() {
        return this.innerProperties() == null ? null : this.innerProperties().apiType();
    }

    public List<RestorableLocationResource> restorableLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().restorableLocations();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

