// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.SqlTriggerCreateUpdateProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** Parameters to create and update Cosmos DB trigger. */
@Fluent
public final class SqlTriggerCreateUpdateParameters extends ArmResourceProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SqlTriggerCreateUpdateParameters.class);

    /*
     * Properties to create and update Azure Cosmos DB trigger.
     */
    @JsonProperty(value = "properties", required = true)
    private SqlTriggerCreateUpdateProperties innerProperties = new SqlTriggerCreateUpdateProperties();

    /**
     * Get the innerProperties property: Properties to create and update Azure Cosmos DB trigger.
     *
     * @return the innerProperties value.
     */
    private SqlTriggerCreateUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public SqlTriggerCreateUpdateParameters withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SqlTriggerCreateUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resource property: The standard JSON format of a trigger.
     *
     * @return the resource value.
     */
    public SqlTriggerResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The standard JSON format of a trigger.
     *
     * @param resource the resource value to set.
     * @return the SqlTriggerCreateUpdateParameters object itself.
     */
    public SqlTriggerCreateUpdateParameters withResource(SqlTriggerResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlTriggerCreateUpdateProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Get the options property: A key-value pair of options to be applied for the request. This corresponds to the
     * headers sent with the request.
     *
     * @return the options value.
     */
    public CreateUpdateOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    /**
     * Set the options property: A key-value pair of options to be applied for the request. This corresponds to the
     * headers sent with the request.
     *
     * @param options the options value to set.
     * @return the SqlTriggerCreateUpdateParameters object itself.
     */
    public SqlTriggerCreateUpdateParameters withOptions(CreateUpdateOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlTriggerCreateUpdateProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property innerProperties in model SqlTriggerCreateUpdateParameters"));
        } else {
            innerProperties().validate();
        }
    }
}
