// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.SqlRoleAssignmentResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Parameters to create and update an Azure Cosmos DB SQL Role Assignment. */
@Fluent
public final class SqlRoleAssignmentCreateUpdateParameters {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SqlRoleAssignmentCreateUpdateParameters.class);

    /*
     * Properties to create and update an Azure Cosmos DB SQL Role Assignment.
     */
    @JsonProperty(value = "properties")
    private SqlRoleAssignmentResource innerProperties;

    /**
     * Get the innerProperties property: Properties to create and update an Azure Cosmos DB SQL Role Assignment.
     *
     * @return the innerProperties value.
     */
    private SqlRoleAssignmentResource innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the roleDefinitionId property: The unique identifier for the associated Role Definition.
     *
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The unique identifier for the associated Role Definition.
     *
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the SqlRoleAssignmentCreateUpdateParameters object itself.
     */
    public SqlRoleAssignmentCreateUpdateParameters withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the scope property: The data plane resource path for which access is being granted through this Role
     * Assignment.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Set the scope property: The data plane resource path for which access is being granted through this Role
     * Assignment.
     *
     * @param scope the scope value to set.
     * @return the SqlRoleAssignmentCreateUpdateParameters object itself.
     */
    public SqlRoleAssignmentCreateUpdateParameters withScope(String scope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withScope(scope);
        return this;
    }

    /**
     * Get the principalId property: The unique identifier for the associated AAD principal in the AAD graph to which
     * access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant
     * associated with the subscription.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The unique identifier for the associated AAD principal in the AAD graph to which
     * access is being granted through this Role Assignment. Tenant ID for the principal is inferred using the tenant
     * associated with the subscription.
     *
     * @param principalId the principalId value to set.
     * @return the SqlRoleAssignmentCreateUpdateParameters object itself.
     */
    public SqlRoleAssignmentCreateUpdateParameters withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SqlRoleAssignmentResource();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
