// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SeedNode model. */
@Fluent
public final class SeedNode {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SeedNode.class);

    /*
     * IP address of this seed node.
     */
    @JsonProperty(value = "ipAddress")
    private String ipAddress;

    /**
     * Get the ipAddress property: IP address of this seed node.
     *
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: IP address of this seed node.
     *
     * @param ipAddress the ipAddress value to set.
     * @return the SeedNode object itself.
     */
    public SeedNode withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
