// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.fluent.models.RestorableDatabaseAccountGetResultInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The List operation response, that contains the restorable database accounts and their properties. */
@Immutable
public final class RestorableDatabaseAccountsListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RestorableDatabaseAccountsListResult.class);

    /*
     * List of restorable database accounts and their properties.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private List<RestorableDatabaseAccountGetResultInner> value;

    /**
     * Get the value property: List of restorable database accounts and their properties.
     *
     * @return the value value.
     */
    public List<RestorableDatabaseAccountGetResultInner> value() {
        return this.value;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
