// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for OperationType. */
public final class OperationType extends ExpandableStringEnum<OperationType> {
    /** Static value Create for OperationType. */
    public static final OperationType CREATE = fromString("Create");

    /** Static value Replace for OperationType. */
    public static final OperationType REPLACE = fromString("Replace");

    /** Static value Delete for OperationType. */
    public static final OperationType DELETE = fromString("Delete");

    /** Static value SystemOperation for OperationType. */
    public static final OperationType SYSTEM_OPERATION = fromString("SystemOperation");

    /**
     * Creates or finds a OperationType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OperationType.
     */
    @JsonCreator
    public static OperationType fromString(String name) {
        return fromString(name, OperationType.class);
    }

    /** @return known OperationType values. */
    public static Collection<OperationType> values() {
        return values(OperationType.class);
    }
}
