// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The core properties of ARM resources. */
@Fluent
public class ManagedCassandraArmResourceProperties extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedCassandraArmResourceProperties.class);

    /*
     * Identity for the resource.
     */
    @JsonProperty(value = "identity")
    private ManagedCassandraManagedServiceIdentity identity;

    /**
     * Get the identity property: Identity for the resource.
     *
     * @return the identity value.
     */
    public ManagedCassandraManagedServiceIdentity identity() {
        return this.identity;
    }

    /**
     * Set the identity property: Identity for the resource.
     *
     * @param identity the identity value to set.
     * @return the ManagedCassandraArmResourceProperties object itself.
     */
    public ManagedCassandraArmResourceProperties withIdentity(ManagedCassandraManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedCassandraArmResourceProperties withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ManagedCassandraArmResourceProperties withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (identity() != null) {
            identity().validate();
        }
    }
}
