// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Cosmos DB Cassandra table schema. */
@Fluent
public final class CassandraSchema {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(CassandraSchema.class);

    /*
     * List of Cassandra table columns.
     */
    @JsonProperty(value = "columns")
    private List<Column> columns;

    /*
     * List of partition key.
     */
    @JsonProperty(value = "partitionKeys")
    private List<CassandraPartitionKey> partitionKeys;

    /*
     * List of cluster key.
     */
    @JsonProperty(value = "clusterKeys")
    private List<ClusterKey> clusterKeys;

    /**
     * Get the columns property: List of Cassandra table columns.
     *
     * @return the columns value.
     */
    public List<Column> columns() {
        return this.columns;
    }

    /**
     * Set the columns property: List of Cassandra table columns.
     *
     * @param columns the columns value to set.
     * @return the CassandraSchema object itself.
     */
    public CassandraSchema withColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    /**
     * Get the partitionKeys property: List of partition key.
     *
     * @return the partitionKeys value.
     */
    public List<CassandraPartitionKey> partitionKeys() {
        return this.partitionKeys;
    }

    /**
     * Set the partitionKeys property: List of partition key.
     *
     * @param partitionKeys the partitionKeys value to set.
     * @return the CassandraSchema object itself.
     */
    public CassandraSchema withPartitionKeys(List<CassandraPartitionKey> partitionKeys) {
        this.partitionKeys = partitionKeys;
        return this;
    }

    /**
     * Get the clusterKeys property: List of cluster key.
     *
     * @return the clusterKeys value.
     */
    public List<ClusterKey> clusterKeys() {
        return this.clusterKeys;
    }

    /**
     * Set the clusterKeys property: List of cluster key.
     *
     * @param clusterKeys the clusterKeys value to set.
     * @return the CassandraSchema object itself.
     */
    public CassandraSchema withClusterKeys(List<ClusterKey> clusterKeys) {
        this.clusterKeys = clusterKeys;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (columns() != null) {
            columns().forEach(e -> e.validate());
        }
        if (partitionKeys() != null) {
            partitionKeys().forEach(e -> e.validate());
        }
        if (clusterKeys() != null) {
            clusterKeys().forEach(e -> e.validate());
        }
    }
}
