// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cosmos.fluent.MongoDBResourcesClient;
import com.azure.resourcemanager.cosmos.fluent.models.BackupInformationInner;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBCollectionGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.MongoDBDatabaseGetResultsInner;
import com.azure.resourcemanager.cosmos.fluent.models.ThroughputSettingsGetResultsInner;
import com.azure.resourcemanager.cosmos.models.ContinuousBackupRestoreLocation;
import com.azure.resourcemanager.cosmos.models.MongoDBCollectionCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.MongoDBCollectionListResult;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseCreateUpdateParameters;
import com.azure.resourcemanager.cosmos.models.MongoDBDatabaseListResult;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in MongoDBResourcesClient. */
public final class MongoDBResourcesClientImpl implements MongoDBResourcesClient {
    private final ClientLogger logger = new ClientLogger(MongoDBResourcesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final MongoDBResourcesService service;

    /** The service client containing this operation class. */
    private final CosmosDBManagementClientImpl client;

    /**
     * Initializes an instance of MongoDBResourcesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    MongoDBResourcesClientImpl(CosmosDBManagementClientImpl client) {
        this.service =
            RestProxy.create(MongoDBResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CosmosDBManagementClientMongoDBResources to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CosmosDBManagementCl")
    private interface MongoDBResourcesService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MongoDBDatabaseListResult>> listMongoDBDatabases(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MongoDBDatabaseGetResultsInner>> getMongoDBDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteMongoDBDatabase(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBDatabaseThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateMongoDBDatabaseThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default"
                + "/migrateToAutoscale")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateMongoDBDatabaseToAutoscale(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/throughputSettings/default"
                + "/migrateToManualThroughput")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateMongoDBDatabaseToManualThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MongoDBCollectionListResult>> listMongoDBCollections(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<MongoDBCollectionGetResultsInner>> getMongoDBCollection(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBCollection(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json")
                MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> deleteMongoDBCollection(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}"
                + "/throughputSettings/default")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBCollectionThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}"
                + "/throughputSettings/default")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> updateMongoDBCollectionThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ThroughputSettingsUpdateParameters updateThroughputParameters,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}"
                + "/throughputSettings/default/migrateToAutoscale")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateMongoDBCollectionToAutoscale(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}"
                + "/throughputSettings/default/migrateToManualThroughput")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> migrateMongoDBCollectionToManualThroughput(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB"
                + "/databaseAccounts/{accountName}/mongodbDatabases/{databaseName}/collections/{collectionName}"
                + "/retrieveContinuousBackupInformation")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformation(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("accountName") String accountName,
            @PathParam("databaseName") String databaseName,
            @PathParam("collectionName") String collectionName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ContinuousBackupRestoreLocation location,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MongoDBDatabaseGetResultsInner>> listMongoDBDatabasesSinglePageAsync(
        String resourceGroupName, String accountName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMongoDBDatabases(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<MongoDBDatabaseGetResultsInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MongoDBDatabaseGetResultsInner>> listMongoDBDatabasesSinglePageAsync(
        String resourceGroupName, String accountName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listMongoDBDatabases(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MongoDBDatabaseGetResultsInner> listMongoDBDatabasesAsync(
        String resourceGroupName, String accountName) {
        return new PagedFlux<>(() -> listMongoDBDatabasesSinglePageAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MongoDBDatabaseGetResultsInner> listMongoDBDatabasesAsync(
        String resourceGroupName, String accountName, Context context) {
        return new PagedFlux<>(() -> listMongoDBDatabasesSinglePageAsync(resourceGroupName, accountName, context));
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MongoDBDatabaseGetResultsInner> listMongoDBDatabases(
        String resourceGroupName, String accountName) {
        return new PagedIterable<>(listMongoDBDatabasesAsync(resourceGroupName, accountName));
    }

    /**
     * Lists the MongoDB databases under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB databases and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MongoDBDatabaseGetResultsInner> listMongoDBDatabases(
        String resourceGroupName, String accountName, Context context) {
        return new PagedIterable<>(listMongoDBDatabasesAsync(resourceGroupName, accountName, context));
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MongoDBDatabaseGetResultsInner>> getMongoDBDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getMongoDBDatabase(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MongoDBDatabaseGetResultsInner>> getMongoDBDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getMongoDBDatabase(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(
                (Response<MongoDBDatabaseGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MongoDBDatabaseGetResultsInner getMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Gets the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB databases under an existing Azure Cosmos DB database account with the provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MongoDBDatabaseGetResultsInner> getMongoDBDatabaseWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return getMongoDBDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBDatabaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateMongoDBDatabaseParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createUpdateMongoDBDatabase(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            createUpdateMongoDBDatabaseParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBDatabaseWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (createUpdateMongoDBDatabaseParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateMongoDBDatabaseParameters is required and cannot be null."));
        } else {
            createUpdateMongoDBDatabaseParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createUpdateMongoDBDatabase(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                createUpdateMongoDBDatabaseParameters,
                accept,
                context);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabaseAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateMongoDBDatabaseWithResponseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters);
        return this
            .client
            .<MongoDBDatabaseGetResultsInner, MongoDBDatabaseGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                MongoDBDatabaseGetResultsInner.class,
                MongoDBDatabaseGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabaseAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateMongoDBDatabaseWithResponseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters, context);
        return this
            .client
            .<MongoDBDatabaseGetResultsInner, MongoDBDatabaseGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                MongoDBDatabaseGetResultsInner.class,
                MongoDBDatabaseGetResultsInner.class,
                context);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabase(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return beginCreateUpdateMongoDBDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters)
            .getSyncPoller();
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MongoDBDatabaseGetResultsInner>, MongoDBDatabaseGetResultsInner>
        beginCreateUpdateMongoDBDatabase(
            String resourceGroupName,
            String accountName,
            String databaseName,
            MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
            Context context) {
        return beginCreateUpdateMongoDBDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters, context)
            .getSyncPoller();
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MongoDBDatabaseGetResultsInner> createUpdateMongoDBDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return beginCreateUpdateMongoDBDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<MongoDBDatabaseGetResultsInner> createUpdateMongoDBDatabaseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
        Context context) {
        return beginCreateUpdateMongoDBDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MongoDBDatabaseGetResultsInner createUpdateMongoDBDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters) {
        return createUpdateMongoDBDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters)
            .block();
    }

    /**
     * Create or updates Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param createUpdateMongoDBDatabaseParameters The parameters to provide for the current MongoDB database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB database.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MongoDBDatabaseGetResultsInner createUpdateMongoDBDatabase(
        String resourceGroupName,
        String accountName,
        String databaseName,
        MongoDBDatabaseCreateUpdateParameters createUpdateMongoDBDatabaseParameters,
        Context context) {
        return createUpdateMongoDBDatabaseAsync(
                resourceGroupName, accountName, databaseName, createUpdateMongoDBDatabaseParameters, context)
            .block();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteMongoDBDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteMongoDBDatabase(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteMongoDBDatabaseWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .deleteMongoDBDatabase(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                context);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteMongoDBDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteMongoDBDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteMongoDBDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteMongoDBDatabaseWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginDeleteMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName, context).getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteMongoDBDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return beginDeleteMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteMongoDBDatabaseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginDeleteMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteMongoDBDatabase(String resourceGroupName, String accountName, String databaseName) {
        deleteMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteMongoDBDatabase(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        deleteMongoDBDatabaseAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getMongoDBDatabaseThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBDatabaseThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getMongoDBDatabaseThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName)
            .flatMap(
                (Response<ThroughputSettingsGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getMongoDBDatabaseThroughput(
        String resourceGroupName, String accountName, String databaseName) {
        return getMongoDBDatabaseThroughputAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Gets the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB database under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getMongoDBDatabaseThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return getMongoDBDatabaseThroughputWithResponseAsync(resourceGroupName, accountName, databaseName, context)
            .block();
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateMongoDBDatabaseThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateMongoDBDatabaseThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            updateThroughputParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateMongoDBDatabaseThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateMongoDBDatabaseThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                updateThroughputParameters,
                accept,
                context);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateMongoDBDatabaseThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateMongoDBDatabaseThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateMongoDBDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBDatabaseThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        return beginUpdateMongoDBDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context)
            .getSyncPoller();
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateMongoDBDatabaseThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateMongoDBDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateMongoDBDatabaseThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return beginUpdateMongoDBDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateMongoDBDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateMongoDBDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters)
            .block();
    }

    /**
     * Update RUs per second of the an Azure Cosmos DB MongoDB database.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     database.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateMongoDBDatabaseThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateMongoDBDatabaseThroughputAsync(
                resourceGroupName, accountName, databaseName, updateThroughputParameters, context)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateMongoDBDatabaseToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .migrateMongoDBDatabaseToAutoscale(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateMongoDBDatabaseToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .migrateMongoDBDatabaseToAutoscale(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToAutoscaleAsync(String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToAutoscaleAsync(
            String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBDatabaseToAutoscaleWithResponseAsync(resourceGroupName, accountName, databaseName, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToAutoscale(String resourceGroupName, String accountName, String databaseName) {
        return beginMigrateMongoDBDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToAutoscale(
            String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginMigrateMongoDBDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateMongoDBDatabaseToAutoscaleAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return beginMigrateMongoDBDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateMongoDBDatabaseToAutoscaleAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginMigrateMongoDBDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBDatabaseToAutoscale(
        String resourceGroupName, String accountName, String databaseName) {
        return migrateMongoDBDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBDatabaseToAutoscale(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return migrateMongoDBDatabaseToAutoscaleAsync(resourceGroupName, accountName, databaseName, context).block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateMongoDBDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .migrateMongoDBDatabaseToManualThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateMongoDBDatabaseToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .migrateMongoDBDatabaseToManualThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToManualThroughputAsync(
            String resourceGroupName, String accountName, String databaseName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBDatabaseToManualThroughputWithResponseAsync(resourceGroupName, accountName, databaseName);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToManualThroughputAsync(
            String resourceGroupName, String accountName, String databaseName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBDatabaseToManualThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToManualThroughput(
            String resourceGroupName, String accountName, String databaseName) {
        return beginMigrateMongoDBDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBDatabaseToManualThroughput(
            String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginMigrateMongoDBDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateMongoDBDatabaseToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return beginMigrateMongoDBDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateMongoDBDatabaseToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return beginMigrateMongoDBDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBDatabaseToManualThroughput(
        String resourceGroupName, String accountName, String databaseName) {
        return migrateMongoDBDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName).block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB database from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBDatabaseToManualThroughput(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return migrateMongoDBDatabaseToManualThroughputAsync(resourceGroupName, accountName, databaseName, context)
            .block();
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MongoDBCollectionGetResultsInner>> listMongoDBCollectionsSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listMongoDBCollections(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<MongoDBCollectionGetResultsInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<MongoDBCollectionGetResultsInner>> listMongoDBCollectionsSinglePageAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listMongoDBCollections(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(), res.getStatusCode(), res.getHeaders(), res.getValue().value(), null, null));
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MongoDBCollectionGetResultsInner> listMongoDBCollectionsAsync(
        String resourceGroupName, String accountName, String databaseName) {
        return new PagedFlux<>(
            () -> listMongoDBCollectionsSinglePageAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<MongoDBCollectionGetResultsInner> listMongoDBCollectionsAsync(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedFlux<>(
            () -> listMongoDBCollectionsSinglePageAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MongoDBCollectionGetResultsInner> listMongoDBCollections(
        String resourceGroupName, String accountName, String databaseName) {
        return new PagedIterable<>(listMongoDBCollectionsAsync(resourceGroupName, accountName, databaseName));
    }

    /**
     * Lists the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List operation response, that contains the MongoDB collections and their properties.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MongoDBCollectionGetResultsInner> listMongoDBCollections(
        String resourceGroupName, String accountName, String databaseName, Context context) {
        return new PagedIterable<>(listMongoDBCollectionsAsync(resourceGroupName, accountName, databaseName, context));
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MongoDBCollectionGetResultsInner>> getMongoDBCollectionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getMongoDBCollection(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<MongoDBCollectionGetResultsInner>> getMongoDBCollectionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getMongoDBCollection(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MongoDBCollectionGetResultsInner> getMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionWithResponseAsync(resourceGroupName, accountName, databaseName, collectionName)
            .flatMap(
                (Response<MongoDBCollectionGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MongoDBCollectionGetResultsInner getMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName).block();
    }

    /**
     * Gets the MongoDB collection under an existing Azure Cosmos DB database account.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the MongoDB collection under an existing Azure Cosmos DB database account.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MongoDBCollectionGetResultsInner> getMongoDBCollectionWithResponse(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return getMongoDBCollectionWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .block();
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBCollectionWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateMongoDBCollectionParameters is required and cannot be null."));
        } else {
            createUpdateMongoDBCollectionParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createUpdateMongoDBCollection(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            createUpdateMongoDBCollectionParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createUpdateMongoDBCollectionWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        if (createUpdateMongoDBCollectionParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter createUpdateMongoDBCollectionParameters is required and cannot be null."));
        } else {
            createUpdateMongoDBCollectionParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .createUpdateMongoDBCollection(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                createUpdateMongoDBCollectionParameters,
                accept,
                context);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollectionAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateMongoDBCollectionWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters);
        return this
            .client
            .<MongoDBCollectionGetResultsInner, MongoDBCollectionGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                MongoDBCollectionGetResultsInner.class,
                MongoDBCollectionGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollectionAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createUpdateMongoDBCollectionWithResponseAsync(
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                createUpdateMongoDBCollectionParameters,
                context);
        return this
            .client
            .<MongoDBCollectionGetResultsInner, MongoDBCollectionGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                MongoDBCollectionGetResultsInner.class,
                MongoDBCollectionGetResultsInner.class,
                context);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollection(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return beginCreateUpdateMongoDBCollectionAsync(
                resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MongoDBCollectionGetResultsInner>, MongoDBCollectionGetResultsInner>
        beginCreateUpdateMongoDBCollection(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
            Context context) {
        return beginCreateUpdateMongoDBCollectionAsync(
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                createUpdateMongoDBCollectionParameters,
                context)
            .getSyncPoller();
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MongoDBCollectionGetResultsInner> createUpdateMongoDBCollectionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return beginCreateUpdateMongoDBCollectionAsync(
                resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<MongoDBCollectionGetResultsInner> createUpdateMongoDBCollectionAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
        Context context) {
        return beginCreateUpdateMongoDBCollectionAsync(
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                createUpdateMongoDBCollectionParameters,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MongoDBCollectionGetResultsInner createUpdateMongoDBCollection(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters) {
        return createUpdateMongoDBCollectionAsync(
                resourceGroupName, accountName, databaseName, collectionName, createUpdateMongoDBCollectionParameters)
            .block();
    }

    /**
     * Create or update an Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param createUpdateMongoDBCollectionParameters The parameters to provide for the current MongoDB Collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB MongoDB collection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MongoDBCollectionGetResultsInner createUpdateMongoDBCollection(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        MongoDBCollectionCreateUpdateParameters createUpdateMongoDBCollectionParameters,
        Context context) {
        return createUpdateMongoDBCollectionAsync(
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                createUpdateMongoDBCollectionParameters,
                context)
            .block();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteMongoDBCollectionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        return FluxUtil
            .withContext(
                context ->
                    service
                        .deleteMongoDBCollection(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteMongoDBCollectionWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return service
            .deleteMongoDBCollection(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                context);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteMongoDBCollectionWithResponseAsync(resourceGroupName, accountName, databaseName, collectionName);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteMongoDBCollectionWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginDeleteMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDeleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return beginDeleteMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName, context)
            .getSyncPoller();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginDeleteMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteMongoDBCollectionAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return beginDeleteMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        deleteMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName).block();
    }

    /**
     * Deletes an existing Azure Cosmos DB MongoDB Collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteMongoDBCollection(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        deleteMongoDBCollectionAsync(resourceGroupName, accountName, databaseName, collectionName, context).block();
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBCollectionThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getMongoDBCollectionThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ThroughputSettingsGetResultsInner>> getMongoDBCollectionThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getMongoDBCollectionThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName)
            .flatMap(
                (Response<ThroughputSettingsGetResultsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner getMongoDBCollectionThroughput(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return getMongoDBCollectionThroughputAsync(resourceGroupName, accountName, databaseName, collectionName)
            .block();
    }

    /**
     * Gets the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     * provided name.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the RUs per second of the MongoDB collection under an existing Azure Cosmos DB database account with the
     *     provided name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ThroughputSettingsGetResultsInner> getMongoDBCollectionThroughputWithResponse(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return getMongoDBCollectionThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .block();
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateMongoDBCollectionThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .updateMongoDBCollectionThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            updateThroughputParameters,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateMongoDBCollectionThroughputWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        if (updateThroughputParameters == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter updateThroughputParameters is required and cannot be null."));
        } else {
            updateThroughputParameters.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .updateMongoDBCollectionThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                updateThroughputParameters,
                accept,
                context);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateMongoDBCollectionThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughputAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateMongoDBCollectionThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateMongoDBCollectionThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters)
            .getSyncPoller();
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginUpdateMongoDBCollectionThroughput(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ThroughputSettingsUpdateParameters updateThroughputParameters,
            Context context) {
        return beginUpdateMongoDBCollectionThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters, context)
            .getSyncPoller();
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> updateMongoDBCollectionThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return beginUpdateMongoDBCollectionThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> updateMongoDBCollectionThroughputAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return beginUpdateMongoDBCollectionThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateMongoDBCollectionThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return updateMongoDBCollectionThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters)
            .block();
    }

    /**
     * Update the RUs per second of an Azure Cosmos DB MongoDB collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param updateThroughputParameters The RUs per second of the parameters to provide for the current MongoDB
     *     collection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner updateMongoDBCollectionThroughput(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ThroughputSettingsUpdateParameters updateThroughputParameters,
        Context context) {
        return updateMongoDBCollectionThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, updateThroughputParameters, context)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateMongoDBCollectionToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .migrateMongoDBCollectionToAutoscale(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateMongoDBCollectionToAutoscaleWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .migrateMongoDBCollectionToAutoscale(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToAutoscaleAsync(
            String resourceGroupName, String accountName, String databaseName, String collectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBCollectionToAutoscaleWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToAutoscaleAsync(
            String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBCollectionToAutoscaleWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToAutoscale(
            String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginMigrateMongoDBCollectionToAutoscaleAsync(
                resourceGroupName, accountName, databaseName, collectionName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToAutoscale(
            String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return beginMigrateMongoDBCollectionToAutoscaleAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateMongoDBCollectionToAutoscaleAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginMigrateMongoDBCollectionToAutoscaleAsync(
                resourceGroupName, accountName, databaseName, collectionName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateMongoDBCollectionToAutoscaleAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return beginMigrateMongoDBCollectionToAutoscaleAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBCollectionToAutoscale(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return migrateMongoDBCollectionToAutoscaleAsync(resourceGroupName, accountName, databaseName, collectionName)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from manual throughput to autoscale.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBCollectionToAutoscale(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return migrateMongoDBCollectionToAutoscaleAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateMongoDBCollectionToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .migrateMongoDBCollectionToManualThroughput(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateMongoDBCollectionToManualThroughputWithResponseAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .migrateMongoDBCollectionToManualThroughput(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToManualThroughputAsync(
            String resourceGroupName, String accountName, String databaseName, String collectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBCollectionToManualThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                this.client.getContext());
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToManualThroughputAsync(
            String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            migrateMongoDBCollectionToManualThroughputWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, context);
        return this
            .client
            .<ThroughputSettingsGetResultsInner, ThroughputSettingsGetResultsInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                ThroughputSettingsGetResultsInner.class,
                ThroughputSettingsGetResultsInner.class,
                context);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToManualThroughput(
            String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginMigrateMongoDBCollectionToManualThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>
        beginMigrateMongoDBCollectionToManualThroughput(
            String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return beginMigrateMongoDBCollectionToManualThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .getSyncPoller();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ThroughputSettingsGetResultsInner> migrateMongoDBCollectionToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return beginMigrateMongoDBCollectionToManualThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<ThroughputSettingsGetResultsInner> migrateMongoDBCollectionToManualThroughputAsync(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return beginMigrateMongoDBCollectionToManualThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBCollectionToManualThroughput(
        String resourceGroupName, String accountName, String databaseName, String collectionName) {
        return migrateMongoDBCollectionToManualThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName)
            .block();
    }

    /**
     * Migrate an Azure Cosmos DB MongoDB collection from autoscale to manual throughput.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an Azure Cosmos DB resource throughput.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ThroughputSettingsGetResultsInner migrateMongoDBCollectionToManualThroughput(
        String resourceGroupName, String accountName, String databaseName, String collectionName, Context context) {
        return migrateMongoDBCollectionToManualThroughputAsync(
                resourceGroupName, accountName, databaseName, collectionName, context)
            .block();
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ContinuousBackupRestoreLocation location) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        } else {
            location.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .retrieveContinuousBackupInformation(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            accountName,
                            databaseName,
                            collectionName,
                            this.client.getApiVersion(),
                            location,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> retrieveContinuousBackupInformationWithResponseAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ContinuousBackupRestoreLocation location,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (accountName == null) {
            return Mono.error(new IllegalArgumentException("Parameter accountName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error(new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (collectionName == null) {
            return Mono.error(new IllegalArgumentException("Parameter collectionName is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error(new IllegalArgumentException("Parameter location is required and cannot be null."));
        } else {
            location.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .retrieveContinuousBackupInformation(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                accountName,
                databaseName,
                collectionName,
                this.client.getApiVersion(),
                location,
                accept,
                context);
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ContinuousBackupRestoreLocation location) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            retrieveContinuousBackupInformationWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, location);
        return this
            .client
            .<BackupInformationInner, BackupInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                BackupInformationInner.class,
                BackupInformationInner.class,
                this.client.getContext());
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformationAsync(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ContinuousBackupRestoreLocation location,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            retrieveContinuousBackupInformationWithResponseAsync(
                resourceGroupName, accountName, databaseName, collectionName, location, context);
        return this
            .client
            .<BackupInformationInner, BackupInformationInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                BackupInformationInner.class,
                BackupInformationInner.class,
                context);
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformation(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ContinuousBackupRestoreLocation location) {
        return beginRetrieveContinuousBackupInformationAsync(
                resourceGroupName, accountName, databaseName, collectionName, location)
            .getSyncPoller();
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BackupInformationInner>, BackupInformationInner>
        beginRetrieveContinuousBackupInformation(
            String resourceGroupName,
            String accountName,
            String databaseName,
            String collectionName,
            ContinuousBackupRestoreLocation location,
            Context context) {
        return beginRetrieveContinuousBackupInformationAsync(
                resourceGroupName, accountName, databaseName, collectionName, location, context)
            .getSyncPoller();
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ContinuousBackupRestoreLocation location) {
        return beginRetrieveContinuousBackupInformationAsync(
                resourceGroupName, accountName, databaseName, collectionName, location)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<BackupInformationInner> retrieveContinuousBackupInformationAsync(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ContinuousBackupRestoreLocation location,
        Context context) {
        return beginRetrieveContinuousBackupInformationAsync(
                resourceGroupName, accountName, databaseName, collectionName, location, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupInformationInner retrieveContinuousBackupInformation(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ContinuousBackupRestoreLocation location) {
        return retrieveContinuousBackupInformationAsync(
                resourceGroupName, accountName, databaseName, collectionName, location)
            .block();
    }

    /**
     * Retrieves continuous backup information for a Mongodb collection.
     *
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param accountName Cosmos DB database account name.
     * @param databaseName Cosmos DB database name.
     * @param collectionName Cosmos DB collection name.
     * @param location The name of the continuous backup restore location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup information of a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public BackupInformationInner retrieveContinuousBackupInformation(
        String resourceGroupName,
        String accountName,
        String databaseName,
        String collectionName,
        ContinuousBackupRestoreLocation location,
        Context context) {
        return retrieveContinuousBackupInformationAsync(
                resourceGroupName, accountName, databaseName, collectionName, location, context)
            .block();
    }
}
