// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties to update Azure Cosmos DB resource throughput. */
@Fluent
public final class ThroughputSettingsUpdateProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ThroughputSettingsUpdateProperties.class);

    /*
     * The standard JSON format of a resource throughput
     */
    @JsonProperty(value = "resource", required = true)
    private ThroughputSettingsResource resource;

    /**
     * Get the resource property: The standard JSON format of a resource throughput.
     *
     * @return the resource value.
     */
    public ThroughputSettingsResource resource() {
        return this.resource;
    }

    /**
     * Set the resource property: The standard JSON format of a resource throughput.
     *
     * @param resource the resource value to set.
     * @return the ThroughputSettingsUpdateProperties object itself.
     */
    public ThroughputSettingsUpdateProperties withResource(ThroughputSettingsResource resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resource() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property resource in model ThroughputSettingsUpdateProperties"));
        } else {
            resource().validate();
        }
    }
}
