// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.ThroughputSettingsGetPropertiesResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** An Azure Cosmos DB resource throughput. */
@Fluent
public final class ThroughputSettingsGetResultsInner extends ArmResourceProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ThroughputSettingsGetResultsInner.class);

    /*
     * The properties of an Azure Cosmos DB resource throughput
     */
    @JsonProperty(value = "properties")
    private ThroughputSettingsGetProperties innerProperties;

    /**
     * Get the innerProperties property: The properties of an Azure Cosmos DB resource throughput.
     *
     * @return the innerProperties value.
     */
    private ThroughputSettingsGetProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ThroughputSettingsGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ThroughputSettingsGetResultsInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the resource property: The resource property.
     *
     * @return the resource value.
     */
    public ThroughputSettingsGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    /**
     * Set the resource property: The resource property.
     *
     * @param resource the resource value to set.
     * @return the ThroughputSettingsGetResultsInner object itself.
     */
    public ThroughputSettingsGetResultsInner withResource(ThroughputSettingsGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ThroughputSettingsGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
